package com.biz.crm.common.ie.sdk.vo;

import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 导出任务进度消息
 *
 * @author sunx
 * @date 2022/5/16
 */
@Data
@ApiModel(value = "ExportProcessMsgVo", description = "导出任务进度消息")
public class ExportProcessMsgVo {
  /** 任务编码 */
  @ApiModelProperty("任务编码")
  private String taskCode;
  /** 是否是主任务 */
  @ApiModelProperty("是否是主任务")
  private Boolean mainFlag = false;
  /**
   * 导入导出类型
   *
   * @see TypeEnum
   */
  @ApiModelProperty("导入导出类型")
  private String ieType = TypeEnum.EXPORT.getDictCode();
  /**
   * 执行状态
   *
   * @see ExecStatusEnum
   */
  @ApiModelProperty("执行状态")
  private String execStatus;
  /**
   * 进度类型
   *
   * @see ExportProcessEnum
   */
  @ApiModelProperty("进度类型")
  private String processType;
  /** 页总数 */
  @ApiModelProperty("页总数")
  private Integer pageSize;
  /** 第几页 */
  @ApiModelProperty("第几页")
  private Integer page = 1;
  /** 当前进度 */
  @ApiModelProperty("当前进度")
  private Integer cursor;
  /** 备注 */
  @ApiModelProperty("备注")
  private String remark;
  /** 时间 */
  @ApiModelProperty("时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "create_time", length = 20, columnDefinition = "datetime COMMENT '创建时间 '")
  private Date time;
  /** 账号 */
  @ApiModelProperty("账号")
  private String account;
  /**
   * 是否开始合并子文件
   */
  @ApiModelProperty("是否开始合并子文件")
  private Boolean isCombine;

  /**
   * 当前任务顺序
   */
  @ApiModelProperty("当前任务顺序")
  private Integer taskSort;
}
