package com.biz.crm.common.ie.sdk.dto;

import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

/**
 * 导出任务创建dto
 *
 * @author sunx
 * @date 2022/5/19
 */
@Data
@ApiModel(value = "CreateExportTaskDto", description = "导出任务创建dto")
public class CreateExportTaskDto {
  /** 导出业务编码 */
  @ApiModelProperty("导出业务编码")
  private String businessCode;
  /** 文件来源 */
  @ApiModelProperty("文件来源")
  private String taskSource;
  /** 数据权限控制所需要的，由head信息携带的MARS_LIST_CODE */
  @ApiModelProperty("数据权限控制所需要的，由head信息携带的MARS_LIST_CODE")
  private String marsListCode;
  /** 个性化设置以及导出字段需要使用菜单编号 */
  @ApiModelProperty("个性化设置以及导出字段需要使用菜单编号")
  private String functionCode;
  /** 个性化设置以及导出字段需要使用上级菜单编号 */
  @ApiModelProperty("个性化设置以及导出字段需要使用上级菜单编号")
  private String parentCode;
  /** 参数 */
  @ApiModelProperty("参数")
  private Map<String, Object> params;
  /** 是否列表工具导出 */
  @ApiModelProperty("是否列表工具导出")
  private Boolean isEuropa;
  /** 列表参数 */
  @ApiModelProperty("列表参数")
  private RequestParameter requestParameter;
  /** 执行过程中形成参数 */
  private String europaInfoCode;
}
