package com.biz.crm.common.ie.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 导入导出任务执行状态
 *
 * @author sunx
 * @date 2022/5/12
 */
@AllArgsConstructor
@Getter
public enum ExecStatusEnum {
  /**
   * 导入任务执行状态
   */
  RUNNING("0", "0", "执行中", "0"),
  DEFAULT("5", "5", "待执行", "5"),
  FINISH("15", "15", "已完成", "10"),
  CANCEL("20", "20", "已取消", "20"),
  FAILED("25", "25", "已失败", "25"),
  PARTIAL_SUCCESS("30", "30", "部分成功", "30"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
