package com.biz.crm.common.ie.sdk.excel.strategy;

import java.util.List;
import java.util.Set;
import com.biz.crm.common.ie.sdk.excel.vo.ColumnVo;
import com.biz.crm.common.ie.sdk.excel.vo.FunctionPermissionVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import cn.hutool.json.JSONObject;

/**
 * 导出数据字段过滤策略(全局配置，针对当前应用中所有的导出业务均使用)
 * 主要用户过滤用户个性化设置以及页面引擎中配置的非导出字段的过滤功能
 *
 * @author keller
 */
public interface CrmExportColumnStrategy {
  
  /**
   * 需要导出的字段名称
   * 
   * @return
   */
  Set<String> exportColumn(ExportTaskProcessVo vo);
  
  /**
   * 获取显示的数据视图字段
   * 
   * @param parentCode
   * @param functionCode
   * @return
   */
  List<ColumnVo> getShowDataviewColumn(String parentCode, String functionCode);
  
  /**
   * 获取显示的数据视图字段
   * 
   * @param funPermVo （parentCode，functionCode）
   * @return
   */
  List<ColumnVo> getShowDataviewColumn(FunctionPermissionVo funPermVo);
  
  /**
   * 填充数据字典
   * 
   * @param excelDataList
   * @param showDataviewColumn
   * @param 数据字典替换关键字段后返回数据
   */
  List<JSONObject> fullDictCode(List<JSONObject> excelDataList, List<ColumnVo> showDataviewColumn);
}
