package com.biz.crm.common.ie.sdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * 导入导出使用的Json转换工具
 * 
 * @author Ken
 * @version 1.0 Copyright 2023年1月3日 下午4:38:19
 */
public class IeJsonUtils {
  private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd hh:mm:ss").create();
  
  /**
   * 对日期格式进行格式化
   * 
   * @return
   */
  public static Gson getGson() {
    return gson;
  }
  
  /**
   * 对日期格式进行格式化
   * 
   * @param results
   * @return
   */
  public static String toJsonString(Object results) {
    String jsonString = gson.toJson(results);
    return jsonString;
  }
  
  /**
   * 对日期格式进行格式化
   * 
   * @param results
   * @return
   */
  public static JSONArray toJSONArray(Object results) {
    String jsonString = toJsonString(results);
    return JSON.parseArray(jsonString);
  }
}
