/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.sdk.excel.strategy;

import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.excel.vo.FunctionPermissionVo;
import com.biz.crm.common.ie.sdk.exception.CrmExportException;
import com.biz.crm.common.ie.sdk.vo.ExcelFileVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskDetailVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.common.ie.sdk.vo.ImportExcelLocalFile;
import com.biz.crm.common.ie.sdk.vo.ImportTaskHandlerResultVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface CrmExcelProcessStrategy {
    default public String getErrorExcelFileName(String fileName) {
        String onlyFileName = fileName.substring(0, fileName.lastIndexOf(46));
        String errorFileName = onlyFileName + "_\u9519\u8bef\u6587\u4ef6.xlsx";
        return errorFileName;
    }

    default public ImportTaskHandlerResultVo importExcel(ImportProcess<?> process, TaskGlobalParamsVo paramsVo, Map<String, Object> params, ImportExcelLocalFile localFile) {
        Map<String, ExcelFileVo> fileMap = localFile.convertFileMap();
        return this.importExcel(process, paramsVo, params, fileMap);
    }

    public ImportTaskHandlerResultVo importExcel(ImportProcess var1, TaskGlobalParamsVo var2, Map<String, Object> var3, Map<String, ExcelFileVo> var4);

    public void exportDetail(ExportTaskProcessVo var1, ExportProcess var2, Map<String, Object> var3, String var4);

    public void exportDetailForEuropa(ExportTaskProcessVo var1, ExportProcess<?> var2, Map<String, Object> var3, String var4, FunctionPermissionVo var5) throws CrmExportException;

    public LinkedHashMap<String, String> merge(ExportTaskProcessVo var1, ExportProcess var2, String var3, List<ExportTaskDetailVo> var4, Map<String, String> var5);

    public void exportDetailForWebApi(ExportTaskProcessVo var1, ExportProcess<?> var2, Map<String, Object> var3, String var4, FunctionPermissionVo var5) throws CrmExportException;
}

