/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.sdk.excel.process;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.excel.util.EuropaParamsTools;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.utils.IeJsonUtils;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.google.common.collect.Maps;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public interface ExportProcess<T extends CrmExcelVo> {
    default public boolean isAsyncGetTotal() {
        return false;
    }

    public Integer getTotal(Map<String, Object> var1);

    public JSONArray getData(ExportTaskProcessVo var1, Map<String, Object> var2);

    public String getBusinessCode();

    public String getBusinessName();

    default public String getTaskFileName(ExportTaskProcessVo task) {
        return null;
    }

    default public Integer getPageSize() {
        return ImportExportConstant.IE_EXPORT_PAGE_SIZE;
    }

    default public Integer getQueryPageSize() {
        return ImportExportConstant.IE_EXPORT_QUERY_PAGE_SIZE;
    }

    default public Integer getMergeFileMaxCount() {
        return null;
    }

    default public Map<String, Object> getGlobalParams() {
        HashMap map = Maps.newHashMap();
        map.put("ie_create_time", DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        return map;
    }

    default public Class<T> findCrmExcelVoClass() {
        Type[] genericInterfaces = this.getClass().getGenericInterfaces();
        Class clazz = (Class)((ParameterizedType)genericInterfaces[0]).getActualTypeArguments()[0];
        return clazz;
    }

    default public Map<String, Object> convertEuropaParam(Map<String, Object> params) {
        return EuropaParamsTools.convertEuropaParam(params);
    }

    default public JSONArray toJSONArray(List<?> list) {
        JSONArray jsonArray = IeJsonUtils.toJSONArray(list);
        return jsonArray;
    }

    default public Pageable buildPageable(Map<String, Object> params) {
        int pageNo = (Integer)params.get("commonPageNo");
        int pageSize = (Integer)params.get("commonPageSize");
        return PageRequest.of((int)pageNo, (int)pageSize);
    }
}

