package com.biz.crm.common.ie.sdk.event;

/**
 * 用户身份记录策略。当导入导出任务创建或者导入导出任务修改的时候。
 * 有的应用程序需要详细记录创建/修改这个导入导出任务的操作者的信息，</p>
 * 
 * 但是不同系统的操作者不一样，需要记录的用户信息是不一样的，例如，厂商用户需要记录的当前操作者的岗位、职位信息等，有的boot系统则需要记录经销商用户的相关信息。</p>
 * 
 * 本监听器提供给不同的boot，根据自己的实际要求，进行相关场景下，用户信息的创建和修改。但是这个策略接口也不是必须实现（当然也可以实现其它附属逻辑），
 * 因为简单来说，使用这个导入导出任务的创建者账号，进行后续导入导出任务实际执行时的用户身份支撑，也是可行的。
 * 
 * @author yinwenjie
 */
public interface ImportExportTaskEventListener {
  /**
   * 当导入导出任务被创建时，该事件被触发。
   * @param isExportTask 是否是导出任务
   * @param taskCode 导入导出任务在系统中唯一的业务编号信息
   * @param appCode 导出导出任务创建时所使用的顶级租户信息
   * @param tenantCode 导出导出任务创建时所使用的二级租户信息
   * @param applicationName 导出导出任务创建时所使用的应用程序信息
   * @param createAccount 导出导出任务创建时所使用的创建者账号信息
   */
  public void onTaskCreate(boolean isExportTask , String taskCode , String appCode , String tenantCode , String applicationName , String createAccount);
}
