package com.biz.crm.common.ie.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 导入阶段枚举
 *
 * @author sunx
 * @date 2022/5/16
 */
@AllArgsConstructor
@Getter
public enum ImportProcessEnum {
  /** 导入阶段枚举 */
  START("start", "开始处理任务......", ""),
  GET_PROCESS("get_process", "获取任务处理器中......", ""),
  DOWNLOAD("download", "加载EXCEL数据中......", ""),
  START_EXEC("start_exec", "导入任务进行中......", ""),
  RUNNING("running", "进行中", "总条数:{}条 当前处理第:{}条 成功数:{}条 失败数:{}条"),
  RUNNING_VERIFY("running_verify", "校验处理中", "数据校验中：总条数:{}条 当前数据校验第:{}条 成功数:{}条 失败数:{}条"),
  RUNNING_SAVE("running_save", "数据保存中", "数据保存中：总条数:{}条 当前数据保存第:{}条 成功数:{}条 失败数:{}条"),
  VERIFY_FAIL("verify_fail", "导入前校验失败!", ""),
  VERIFY_SUCCESS("verify_success", "导入前校验成功!", ""),
  END_EXEC("end_exec", "处理完成", "处理完成，当前任务数据总行数:{}条 成功数:{}条 失败数:{}条"),
  ERROR_DATA("error_data", "正在处理失败数据......", ""),
  UPDATE_TASK("update_task", "正在更新任务状态......", ""),
  END("end", "任务处理完成", ""),
  ;
  /** code */
  private String code;
  /** 字典编码 */
  private String desc;
  /** 消息格式 */
  private String format;
}
