package com.biz.crm.common.ie.sdk.event;

import com.biz.crm.common.ie.sdk.vo.ExportTaskEventVo;

/**
 * @author ning.zhang
 * @description 导出通知事件监听器(导出结果通知上层业务事件)
 * @date 2024/09/14
 */
public interface ExportNotifyEventListener {

  /**
   * 当导出任务执行成功之后触发
   *
   * @param eventVo 导出任务信息
   */
  void onSuccess(ExportTaskEventVo eventVo);

  /**
   * 当导出任务执行失败之后触发
   *
   * @param eventVo 导出任务信息
   */
  void onFail(ExportTaskEventVo eventVo);
}
