/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.sdk.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.vo.EsParagraphFieldRangeVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.bizunited.nebula.common.register.ElasticsearchQueryRegister;
import com.bizunited.nebula.common.service.es.ElasticsearchQueryService;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractEsParagraphExportProcess<T extends CrmExcelVo>
implements ExportProcess<T> {
    @Autowired(required=false)
    private ElasticsearchQueryService elasticsearchQueryService;

    public abstract Class<? extends ElasticsearchQueryRegister> getElasticsearchQueryRegister();

    @Override
    public Integer getTotal(Map<String, Object> params) {
        ElasticsearchQueryRegister queryRegister = this.elasticsearchQueryService.findRegisterByClass(this.getElasticsearchQueryRegister());
        Validate.notNull((Object)queryRegister, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684ES\u67e5\u8be2\u6ce8\u518c\u5668\u5b9e\u73b0", (Object[])new Object[0]);
        SearchSourceBuilder sourceBuilder = queryRegister.buildSearch(params);
        sourceBuilder.from(0);
        sourceBuilder.size(1);
        sourceBuilder.trackTotalHits(true);
        SearchRequest searchRequest = new SearchRequest(new String[]{queryRegister.getIndexName()}).source(sourceBuilder);
        SearchResponse searchResponse = this.elasticsearchQueryService.queryWithRequest(searchRequest);
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getHits()) || Objects.isNull(searchResponse.getHits().getTotalHits())) {
            return 0;
        }
        TotalHits totalHits = searchResponse.getHits().getTotalHits();
        return (int)totalHits.value;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        List<EsParagraphFieldRangeVo> paragraphFieldRanges = vo.getQueryParagraphFieldRanges();
        Validate.isTrue((!CollectionUtils.isEmpty(paragraphFieldRanges) ? 1 : 0) != 0, (String)"ES\u5206\u6bb5\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
        ElasticsearchQueryRegister queryRegister = this.elasticsearchQueryService.findRegisterByClass(this.getElasticsearchQueryRegister());
        Validate.notNull((Object)queryRegister, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684ES\u67e5\u8be2\u6ce8\u518c\u5668\u5b9e\u73b0", (Object[])new Object[0]);
        SearchSourceBuilder sourceBuilder = queryRegister.buildSearch(params);
        sourceBuilder.sorts().clear();
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        paragraphFieldRanges.forEach(fieldRangeVo -> {
            builder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldRangeVo.getFieldName()).lte(fieldRangeVo.getEnd()).gte(fieldRangeVo.getStart()));
            sourceBuilder.sort(fieldRangeVo.getFieldName(), SortOrder.fromString((String)fieldRangeVo.getSort()));
        });
        if (Objects.nonNull(sourceBuilder.query())) {
            builder.must(sourceBuilder.query());
        }
        sourceBuilder.query((QueryBuilder)builder);
        sourceBuilder.from(0);
        sourceBuilder.size(this.getQueryPageSize().intValue());
        SearchRequest searchRequest = new SearchRequest(new String[]{queryRegister.getIndexName()}).source(sourceBuilder);
        SearchResponse searchResponse = this.elasticsearchQueryService.queryWithRequest(searchRequest);
        List mapList = this.elasticsearchQueryService.convertResponse(searchResponse, Map.class);
        return this.toJSONArray(mapList);
    }

    @Override
    public Integer getQueryPageSize() {
        return ImportExportConstant.IE_ES_EXPORT_QUERY_PAGE_SIZE;
    }

    @Override
    public Class<T> findCrmExcelVoClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

