package com.biz.crm.common.ie.sdk.constant;

/**
 * 导入 导出常量
 *
 * @author sunx
 * @date 2022/5/10
 */
public class ImportExportConstant {

  private ImportExportConstant() {}


  /** 导入任务factory前缀 */
  public static final String IMPORT_TASK_FACTORY_NAME_PREFIX_FORMAT = "bz-import-task-{}-";

  /** 导出任务factory前缀 */
  public static final String EXPORT_TASK_FACTORY_NAME_PREFIX_FORMAT = "bz-export-task-{}-{}-";
  /** 导出获取total任务factory前缀 */
  public static final String EXPORT_GET_TOTAL_TASK_FACTORY_NAME_PREFIX_FORMAT = "bz-export-task-getTotal-{}-";
  /** 导出ES分段任务factory前缀 */
  public static final String EXPORT_ES_PARAGRAPH_TASK_FACTORY_NAME_PREFIX_FORMAT = "bz-export-es-paragraph-{}-";
  /** 导出任务factory前缀[增强，用于阻塞队列] */
  public static final String EXPORT_TASK_FACTORY_NAME_PREFIX_FORMAT_PRIORITY = "bz-export-task-ext-{}-";

  /** 导入导出加载任务锁 */
  public static final String IE_LOAD_LOCK_PREFIX_FORMAT = "bz:crm:ie:{}:lock";

  /** 导出回调锁 */
  public static final String IE_EXPORT_CALL_BACK_LOCK_PREFIX_FORMAT = "bz:crm:ie:export:lock:{}";

  /** 导入回调锁 */
  public static final String IE_IMPORT_CALL_BACK_LOCK_PREFIX_FORMAT = "bz:crm:ie:import:lock:{}";

  /** 用于记录当前是哪个机器获取走了导出权限 */
  public static final String IE_LOAD_LOCK_SERVER_PREFIX_FORMAT = "bz:crm:ie:{}:serv";
  
  /** websocket 内网地址 redis-key 前缀 */
  public static final String IE_MAIN_HOST_PREFIX_FORMAT = "bz:crm:ie:{}:host";

  
  /** 导入任务编码前缀 */
  public static final String IMPORT_TASK_CODE_PREFIX = "IT";

  /** 导出任务编码前缀 */
  public static final String EXPORT_TASK_CODE_PREFIX = "ET";

  /** 导出主任务redis-key前缀 */
  public static final String EXPORT_TASK_KEY_PREFIX_FORMAT = "bz:crm:ie:ex:{}";

  /** 文件后缀 */
  public static final String IE_FILE_SUFFIX = ".xlsx";

  /** 错误文件后缀 */
  public static final String IE_ERROR_FILE_SUFFIX = "_错误文件.xlsx";

  /** 默认创建时间 */
  public static final String IE_PARAMS_CREATE_TIME = "ie_create_time";

  /** 导出-列表权限参数 */
  public static final String IE_PARAMS_LIST_CODE = "ie_list_code";

  /** 导入默认页处理大小 */
  public static final Integer IE_IMPORT_PAGE_SIZE = 500;

  /** 导出子任务拆分大小 */
  public static final Integer IE_EXPORT_PAGE_SIZE = 20000;

  /** 导出子任务查询数据分页大小 */
  public static final Integer IE_EXPORT_QUERY_PAGE_SIZE = 2000;

  /** 最大导入行数,默认50000**/
  public static final Integer IE_IMPORT_LIMIT_ROW_NUM = 50000;

  /** ES导出子任务查询数据分页大小 */
  public static final Integer IE_ES_EXPORT_QUERY_PAGE_SIZE = 10000;

  public static final String SHEET1 = "Sheet1";
  
  /** europa导出业务编码 */
  public static final String EXPORT_BIZ_CODE_MDM_EUROPA_CODE = "MDM_EUROPA_EXPORT";
  
  /** europa异步导出业务编码 */
  public static final String EXPORT_BIZ_CODE_MDM_EUROPA_ASYNC_CODE = "MDM_EUROPA_EXPORT_ASYNC";


  /** WebApi导出业务编码 MDM_EXPORT_WEB_API */
  public static final String EXPORT_BIZ_CODE_EXPORT_WEB_API = "EXPORT_WEB_API";

  /** WebApi异步导出业务编码 MDM_EXPORT_WEB_API */
  public static final String EXPORT_BIZ_CODE_EXPORT_WEB_API_ASYNC = "EXPORT_WEB_API_ASYNC";

  /**
   * 主任务只推一次
   */
  public static final String ONE_MAIN_FLAG = "0";

  /**
   * 所有业务所属通道标识
   */
  public static final String IE_CHANNEL_TASK_CODE = "CRM_ALL";
  /**
   * 导入导出公用通道
   */
  public static final String IE_EXPORT_IMPORT_MODEL_CODE = "ie_export_import_model";
  /**
   * 导出任务创建redis锁KEY
   */
  public static final String IE_EXPORT_CREATE_REDIS_LOCK_KEY = "ie_export_create_lock";
  /**
   * 导出任务公共参数分页大小
   */
  public static final String IE_EXPORT_COMMON_PARAM_PAGE_SIZE = "commonPageSize";
  /**
   * 导出任务公共参数分页页数
   */
  public static final String IE_EXPORT_COMMON_PARAM_PAGE_NO = "commonPageNo";
}
