package com.biz.crm.common.ie.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;

/**
 * 导入数据状态
 */
@AllArgsConstructor
@Getter
public enum ImportDataStatusEnum {
  /** * 校验失败 */
  VERIFY_FAILED("JYSB", "JYSB", "校验失败", "10"),
  /** 校验部分失败 */
  VERIFY_FAILED_SECTION("JYBFSB", "JYBFSB", "校验部分失败", "20"),
  /** 导入成功 */
  IMPORT_SUCCESS("DRCG", "DRCG", "导入成功", "30"),
  /** 导入失败 */
  IMPORT_FAILED("DRSB", "DRSB", "导入失败", "40"),
  /** 导入部分失败 */
  IMPORT_FAILED_SECTION("DRBFSB", "DRBFSB", "导入部分失败", "50"),
  ;

  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

}
