/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.sdk.excel.util;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EuropaParamsTools {
    public static final String EUROPA_CODE_PARAMETER_NAME = "europaInfoCode";
    private static final Pattern europaPattern = Pattern.compile("(_\\d+)$");

    public static boolean isEuropaParam(Map<String, Object> params) {
        return params.containsKey(EUROPA_CODE_PARAMETER_NAME);
    }

    public static Map<String, Object> convertEuropaParam(Map<String, Object> params) {
        if (!EuropaParamsTools.isEuropaParam(params)) {
            return params;
        }
        HashMap map = Maps.newHashMap();
        params.forEach((key, value) -> {
            String handleKey = key;
            Matcher matcher = europaPattern.matcher((CharSequence)key);
            if (matcher.find()) {
                String subString = matcher.replaceAll("");
                handleKey = StrUtil.toCamelCase((CharSequence)subString);
            }
            map.put(handleKey, value);
        });
        return map;
    }
}

