package com.biz.crm.common.ie.sdk.dto;

import lombok.Data;
import lombok.ToString;

/**
 * @author XXLsansui
 * @date 2023-06-12 14:21
 * @description：导出任务排队列表
 */
@Data
@ToString(callSuper = true)
public class ExportTaskQueueDto implements Comparable{
  /**
   * 主任务编码
   */
  private String taskCode;
  /**
   * 账号
   */
  private String account;
  /**
   * 文件大小 数据总条数
   */
  private Integer totalSize;
  /**
   * 是否主任务 true:主任务 false:子任务
   */
  private boolean mainFlag = true;

  /**
   * Compares this object with the specified object for order.  Returns a
   * negative integer, zero, or a positive integer as this object is less
   * than, equal to, or greater than the specified object.
   *
   * <p>The implementor must ensure <tt>sgn(x.compareTo(y)) ==
   * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
   * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
   * <tt>y.compareTo(x)</tt> throws an exception.)
   *
   * <p>The implementor must also ensure that the relation is transitive:
   * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
   * <tt>x.compareTo(z)&gt;0</tt>.
   *
   * <p>Finally, the implementor must ensure that <tt>x.compareTo(y)==0</tt>
   * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
   * all <tt>z</tt>.
   *
   * <p>It is strongly recommended, but <i>not</i> strictly required that
   * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
   * class that implements the <tt>Comparable</tt> interface and violates
   * this condition should clearly indicate this fact.  The recommended
   * language is "Note: this class has a natural ordering that is
   * inconsistent with equals."
   *
   * <p>In the foregoing description, the notation
   * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
   * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
   * <tt>0</tt>, or <tt>1</tt> according to whether the value of
   * <i>expression</i> is negative, zero or positive.
   *
   * @param o the object to be compared.
   * @return a negative integer, zero, or a positive integer as this object
   * is less than, equal to, or greater than the specified object.
   * @throws NullPointerException if the specified object is null
   * @throws ClassCastException   if the specified object's type prevents it
   *                              from being compared to this object.
   */
  @Override
  public int compareTo(Object o) {
    int compare = Integer.compare(this.getTotalSize(), ((ExportTaskQueueDto)o).getTotalSize());
    if (compare == 0) {
      // 两个任务同属于大任务或小任务，按照任务编号进行排序
      return this.getTaskCode().compareTo(((ExportTaskQueueDto)o).getTaskCode());
    } else {
      return compare;
    }
  }
}
