package com.biz.crm.common.itextpdf.local.controller;

import cn.hutool.extra.template.TemplateException;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.itextpdf.local.service.ITextPdfVoService;
import com.biz.crm.dms.business.itextpdf.sdk.vo.dto.ITextPdfDto;
import com.biz.crm.vo.UploadVo;
import com.bizunited.nebula.common.util.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * @description: itextpdf相关的http
 * @author: rentao
 * @date: 2022/4/25 15:36
 */
@RestController
@RequestMapping("/v1/itextpdf/iTextPdf")
@Api(tags = "itextpdf相关的http")
@Slf4j
public class ITextPdfVoController {

  @Autowired(required = false)
  private ITextPdfVoService iTextPdfVoService;

  /**
   * 通过file文件获取pdf
   * @param iTextPdfDto
   * @return
   */
  @ApiOperation(value = "通过file文件获取pdf")
  @PostMapping("/createPdfByFile")
  public Result<UploadVo> createPdfByFile(@RequestBody ITextPdfDto iTextPdfDto) {
    try {
      MultipartFile file = iTextPdfDto.getFile();
      return Result.ok(this.iTextPdfVoService.createPdfByFile(file));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过html获取pdf
   * @param iTextPdfDto
   * @return
   */
  @ApiOperation(value = "通过html获取pdf")
  @PostMapping("/createPdfByHtml")
  public Result<UploadVo> createPdfByHtml(@RequestBody ITextPdfDto iTextPdfDto) {
    try {
      String html = iTextPdfDto.getHtmlStr();
      return Result.ok(this.iTextPdfVoService.createPdfByHtml(html));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * pdf文件预览
   * @param iTextPdfDto
   * @param response
   * @return
   */
  @ApiOperation(value = "通过html预览pdf")
  @PostMapping("/reviewDataPdf")
  public void reviewPdfByHtml(@RequestBody ITextPdfDto iTextPdfDto,HttpServletResponse response){
    try {
      // 获取pdf文件路径（包括文件名）
       String html = iTextPdfDto.getHtmlStr();
       this.iTextPdfVoService.reviewPdfByHtml(html,response);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
    }
  }
}

