package com.biz.crm.common.itextpdf.local.service.internal;
import com.biz.crm.UploadService;
import com.biz.crm.common.itextpdf.local.service.FileUploadVoService;
import com.biz.crm.vo.UploadVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;


/**
 * @description: 文件上传
 * @author: rentao
 * @date: 2022/4/29 15:00
 */
@Service
@Slf4j
public class FileUploadVoServiceImpl implements FileUploadVoService {

  @Autowired(required = false) private UploadService uploadService;


  @Override
  public UploadVo upload(MultipartFile multipartFile) {
    UploadVo uploadVo = null;
    try {
      List<UploadVo> uploadVos = this.uploadService.uploadOss(multipartFile);
      uploadVo = uploadVos.get(0);
    } catch (Exception e) {
      Validate.isTrue(false, "上传错误文件失败");
    }
    return uploadVo;
  }
}
