package com.biz.crm.common.itextpdf.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.itextpdf.sdk.service.ITextPdfVoService;
import com.biz.crm.dms.business.itextpdf.sdk.dto.ITextPdfDto;
import com.biz.crm.dms.business.itextpdf.sdk.dto.WordTemplateDataVo;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * @description: itextpdf相关的http
 * @author: rentao
 * @date: 2022/4/25 15:36
 */
@RestController
@RequestMapping("/v1/itextpdf/iTextPdf")
@Api(tags = "itextpdf相关的http")
@Slf4j
public class ITextPdfVoController {
  @Autowired(required = false)
  private ITextPdfVoService iTextPdfVoService;

  /**
   * 通过file文件获取pdf
   * @param iTextPdfDto
   * @return
   */
  @ApiOperation(value = "通过file文件获取pdf")
  @PostMapping("/createPdfByFile")
  public Result<OrdinaryFileVo> createPdfByFile(@RequestBody ITextPdfDto iTextPdfDto) {
    try {
      MultipartFile file = iTextPdfDto.getFile();
      return Result.ok(this.iTextPdfVoService.createPdfByFile(file));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过html获取pdf
   * @param iTextPdfDto
   * @return
   */
  @ApiOperation(value = "通过html获取pdf")
  @PostMapping("/createPdfByHtml")
  public Result<OrdinaryFileVo> createPdfByHtml(@RequestBody ITextPdfDto iTextPdfDto) {
    try {
      String html = iTextPdfDto.getHtmlStr();
      return Result.ok(this.iTextPdfVoService.createPdfByHtml(html));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * pdf文件预览
   * @param iTextPdfDto
   * @param response
   * @return
   */
  @ApiOperation(value = "通过html预览pdf")
  @PostMapping("/reviewDataPdf")
  public void reviewPdfByHtml(@RequestBody ITextPdfDto iTextPdfDto,HttpServletResponse response){
    try {
      // 获取pdf文件路径（包括文件名）
       String html = iTextPdfDto.getHtmlStr();
       this.iTextPdfVoService.reviewPdfByHtml(html,response);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
    }
  }

  /**
   * 创建文档并转pdf
   *
   * @param dataVo 模板数据
   * @return pdf文件信息
   */
  @ApiOperation(value = "创建文档并转pdf")
  @PostMapping("/createWordToPdfFile")
  public Result<OrdinaryFileVo> createWordDocxToPdfFile(@RequestBody WordTemplateDataVo dataVo) {
    OrdinaryFileVo ordinaryFileVo = this.iTextPdfVoService.createWordDocxToPdfFile(dataVo);
    return Result.ok(ordinaryFileVo);
  }
}

