package com.biz.crm.dms.business.itextpdf.sdk.service;

import javax.servlet.http.HttpServletResponse;

import com.biz.crm.dms.business.itextpdf.sdk.dto.WordTemplateDataVo;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import org.springframework.web.multipart.MultipartFile;

/**
 * @description: 转pdf并上传
 * @author: rentao
 * @date: 2022/4/25 15:37
 */
public interface ITextPdfVoService {

  /**
   * file转pdf（直转）
   * @param html
   */
  OrdinaryFileVo createPdfByFile(MultipartFile html);

  /**
   * html转pdf（直转）
   * @param html
   */
  OrdinaryFileVo createPdfByHtml(String html);

  /**
   * html 预览 pdf
   * @param htmlStr
   * @param response
   */
  void reviewPdfByHtml(String htmlStr, HttpServletResponse response);

  /**
   * 创建文档并转pdf
   *
   * @param dataVo 模板数据
   * @return pdf文件信息
   */
  OrdinaryFileVo createWordDocxToPdfFile(WordTemplateDataVo dataVo);
}

