/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.itextpdf.sdk.utils;

import com.aspose.words.Document;
import com.aspose.words.License;
import com.biz.crm.dms.business.itextpdf.sdk.utils.WordUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class WordSwitchPdfUtil {
    private static final Logger log = LoggerFactory.getLogger(WordSwitchPdfUtil.class);
    private static String BASE_DIR;

    @Value(value="${server.tomcat.basedir:}")
    public void setBaseDir(String baseDir) {
        BASE_DIR = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertDocx2Pdf(String wordPath, String wordName) {
        String pdfPath = BASE_DIR + File.separator + wordName + File.separator + wordName + ".pdf";
        FileOutputStream os = null;
        if (WordSwitchPdfUtil.getLicense()) {
            try {
                File file = new File(pdfPath);
                if (!file.exists()) {
                    file.createNewFile();
                }
                os = new FileOutputStream(file);
                Document doc = new Document(wordPath);
                doc.save((OutputStream)os, 40);
                WordUtil.safeClose(os);
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                String string = null;
                return string;
            }
            finally {
                WordUtil.safeClose(os);
            }
        } else {
            return null;
        }
        return pdfPath;
    }

    public static boolean getLicense() {
        try {
            ClassPathResource classPathResource = new ClassPathResource("License.xml");
            License license = new License();
            license.setLicense(classPathResource.getInputStream());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

