package com.biz.crm.common.log.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.log.local.repository.CrmBusinessLogEsRepository;
import com.biz.crm.common.log.local.utils.CrmBusinessLogUtil;
import com.biz.crm.common.log.local.utils.LogCompare;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 业务日志service
 * @author: rentao
 * @date: 2022/5/13 20:17
 */
@Service
@Slf4j
public class CrmBusinessLogVoServiceImpl implements CrmBusinessLogVoService {

  @Autowired(required = false)
  private CrmBusinessLogEsRepository crmBusinessLogRepository;
  @Autowired
  private LoginUserService loginUserService;


  @Override
  @Transactional
  public void handleSave(CrmBusinessLogDto crmBusinessLogDto) {
    Validate.notNull(crmBusinessLogDto, "传入比对参数不存在！");
    Validate.notBlank(crmBusinessLogDto.getOperationType(), "记录业务日志时，操作类型不能为空！");
    Validate.notBlank(crmBusinessLogDto.getTenantCode(), "记录业务日志时，租户信息不能为空！");
    String operationType = crmBusinessLogDto.getOperationType();
    LoginDetails loginUser = this.loginUserService.getLoginUser();
    if (Objects.nonNull(loginUser)) {
      crmBusinessLogDto.setCreateAccount(loginUser.getAccount());
      crmBusinessLogDto.setCreateName(loginUser.getUsername());
      if (OperationTypeEunm.CREATE.getDictCode().equals(operationType)) {
        this.crmBusinessLogRepository
            .saveAll(CrmBusinessLogUtil.voToEntityForAdd(crmBusinessLogDto));
      } else if (OperationTypeEunm.DELETE.getDictCode().equals(operationType)) {
        this.crmBusinessLogRepository
            .saveAll(CrmBusinessLogUtil.voToEntityForDel(crmBusinessLogDto));
      } else {
        Object resullt = LogCompare
            .compareObject(JSON.toJSONString(crmBusinessLogDto.getOldObject(),
                SerializerFeature.WriteMapNullValue),
                JSON.toJSONString(crmBusinessLogDto.getNewObject(),
                    SerializerFeature.WriteMapNullValue));
        this.crmBusinessLogRepository
            .save(CrmBusinessLogUtil.voToEntityForUpdate(crmBusinessLogDto, resullt));
      }
    }

  }
}
