package com.biz.crm.common.log.local.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * @description: 对多对比
 * @author: rentao
 * @date: 2022/5/10 14:11
 */
public class ManyConpare {

  //集合中唯一键
  private static final String ONLY_KEY = "id";

  /*
   *
   * 集合对比
   * @param oldJsonObjects
   * @param newJsonObjects
   * @author rentao
   * @date
   */
  public static List<JSONObject> compare(List<JSONObject> oldJsonObjects,
      List<JSONObject> newJsonObjects) {
    List<JSONObject> reList = new ArrayList();
    List<JSONObject> oldJsons =
        CollectionUtils.isEmpty(oldJsonObjects) ? new ArrayList() : oldJsonObjects;
    List<JSONObject> newJsons =
        CollectionUtils.isEmpty(newJsonObjects) ? new ArrayList() : newJsonObjects;
    Set<Map<String, JSONObject>> updateList = new HashSet<>();
    List<JSONObject> listOld = transforToMapByOnlyKeyNull(oldJsons, ONLY_KEY);
    List<JSONObject> listNew = transforToMapByOnlyKeyNull(newJsons, ONLY_KEY);
    Map<String, JSONObject> oldJsonObjectMap = transforToMapByOnlyKeyNotNull(oldJsons, ONLY_KEY);
    Map<String, JSONObject> newJsonObjectMap = transforToMapByOnlyKeyNotNull(newJsons, ONLY_KEY);
    Iterator iterator;
    Entry entry;
    JSONObject result;
    StringBuilder stb;
    JSONObject json;
    HashMap map;
    for (JSONObject jsonObject : listOld) {
      stb = new StringBuilder("删除了：");
      json = new JSONObject();
      json.put(stb.toString(), jsonObject);
      reList.add(json);
    }
    for (JSONObject jsonObject : listNew) {
      stb = new StringBuilder("新增了：");
      json = new JSONObject();
      json.put(stb.toString(), jsonObject);
      reList.add(json);
    }
    if (!CollectionUtils.isEmpty(oldJsonObjects)) {
      iterator = oldJsonObjectMap.entrySet().iterator();
      while (iterator.hasNext()) {
        entry = (Entry) iterator.next();
        result = newJsonObjectMap.get(entry.getKey());
        if (null == result) {
          stb = new StringBuilder("删除了：");
          stb.append((String) entry.getKey());
          json = new JSONObject();
          json.put(stb.toString(), entry.getValue());
          reList.add(json);
        } else {
          map = new HashMap();
          map.put("old", entry.getValue());
          map.put("new", result);
          updateList.add(map);
        }
      }
    }
    if (!CollectionUtils.isEmpty(newJsonObjects)) {
      iterator = newJsonObjectMap.entrySet().iterator();
      while (iterator.hasNext()) {
        entry = (Entry) iterator.next();
        result = oldJsonObjectMap.get(entry.getKey());
        if (null == result) {
          stb = new StringBuilder("新创建了:");
          stb.append((String) entry.getKey());
          json = new JSONObject();
          json.put(stb.toString(), entry.getValue());
          reList.add(json);
        } else {
          map = new HashMap();
          map.put("old", result);
          map.put("new", entry.getValue());
          updateList.add(map);
        }
      }
    }
    if (CollectionUtils.isEmpty(updateList)) {
      return reList;
    } else {
      iterator = updateList.iterator();
      while (iterator.hasNext()) {
        Map<String, JSONObject> map1 = (Map) iterator.next();
        result = OneCompare.compare(map1.get("old"), map1.get("new"));
        if (result != null && !result.isEmpty()) {
          reList.add(result);
        }
      }
      return reList;
    }
  }

  public static String packageOnlykey(JSONObject value, String onlyKeyValue) {
    String[] keys = onlyKeyValue.split(",");
    StringBuilder onlyKey = new StringBuilder();
    String[] onlyKeys = keys;
    int length = keys.length;
    for (int i = 0; i < length; ++i) {
      String str = onlyKeys[i];
      Object obj = value.get(str);
      if (!StringUtils.isEmpty(obj)) {
        onlyKey.append(obj);
      }
    }
    return onlyKey.toString();
  }

  //这里需要把id不是空的全部取出来
  public static Map transforToMapByOnlyKeyNotNull(List<JSONObject> jsonObjects,
      String onlyKeyValue) {
    if (CollectionUtils.isEmpty(jsonObjects)) {
      return new HashMap();
    } else {
      Map reMap = new HashMap(jsonObjects.size());
      Iterator iterator = jsonObjects.iterator();
      while (iterator.hasNext()) {
        JSONObject object = (JSONObject) iterator.next();
        if (!StringUtils.isEmpty(packageOnlykey(object, onlyKeyValue))) {
          reMap.put(packageOnlykey(object, onlyKeyValue), object);
        }
      }
      return reMap;
    }
  }


  //这里需要把id空的全部取出来
  public static List transforToMapByOnlyKeyNull(List<JSONObject> jsonObjects, String onlyKeyValue) {
    if (CollectionUtils.isEmpty(jsonObjects)) {
      return new ArrayList();
    } else {
      List arrayList = new ArrayList();
      Iterator iterator = jsonObjects.iterator();
      while (iterator.hasNext()) {
        JSONObject object = (JSONObject) iterator.next();
        if (StringUtils.isEmpty(packageOnlykey(object, onlyKeyValue))) {
          arrayList.add(object);
        }
      }
      return arrayList;
    }
  }
}
