/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.log.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.local.service.CrmBusinessLogService;
import com.biz.crm.common.log.local.utils.LogTransform;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogQueryDto;
import com.biz.crm.common.log.sdk.strategy.CrmBusinessLogStrategyService;
import com.biz.crm.common.log.sdk.utils.EsUtil;
import com.biz.crm.common.log.sdk.vo.CrmBusinessLogEsVo;
import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrmBusinessLogServiceImpl
implements CrmBusinessLogService {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessLogServiceImpl.class);
    @Autowired
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Autowired(required=false)
    private List<CrmBusinessLogStrategyService> crmBusinessLogStrategyServices;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<CrmBusinessLogEsVo> findByConditions(Pageable pageable, CrmBusinessLogQueryDto crmBusinessLogDto) {
        Validate.notNull((Object)crmBusinessLogDto, (String)"\u67e5\u8be2\u65e5\u5fd7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)crmBusinessLogDto.getOnlyKey(), (String)"\u67e5\u8be2\u65e5\u5fd7,\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)crmBusinessLogDto.getAccessType(), (String)"\u67e5\u8be2\u65e5\u5fd7,\u83b7\u53d6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        if (!EsUtil.indexExsitNoCreate((ElasticsearchRestTemplate)this.elasticsearchRestTemplate, CrmBusinessLogEsEntity.class)) {
            return null;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"onlyKey.keyword", (String)crmBusinessLogDto.getOnlyKey()));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"appCode.keyword", (String)TenantUtils.getAppCode()));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantCode.keyword", (String)TenantUtils.getTenantCode()));
        if (null != crmBusinessLogDto.getOperationType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"operationType.keyword", (String)crmBusinessLogDto.getOperationType()));
        }
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withSort(SortBuilders.fieldSort((String)"createTimeTimeNum").unmappedType("keyword").order(SortOrder.DESC)).withPageable((Pageable)PageRequest.of((int)(pageable.getPageNumber() - 1), (int)pageable.getPageSize())).build();
        SearchHits searchs = this.elasticsearchRestTemplate.search((Query)searchQuery, CrmBusinessLogEsEntity.class);
        List crmLogEntityList = searchs.get().map(SearchHit::getContent).collect(Collectors.toList());
        ArrayList<CrmBusinessLogEsVo> crmBusinessLogEsEntities = new ArrayList<CrmBusinessLogEsVo>();
        if (!CollectionUtils.isEmpty(crmLogEntityList) && StringUtils.isNotBlank((CharSequence)crmBusinessLogDto.getParentCode())) {
            List crmBusinessLogEsVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(crmLogEntityList, CrmBusinessLogEsEntity.class, CrmBusinessLogEsVo.class, HashSet.class, ArrayList.class, new String[0]);
            crmBusinessLogEsEntities.addAll(this.handleFiledTransformation(crmBusinessLogEsVoList, crmBusinessLogDto.getAccessType(), crmBusinessLogDto.getParentCode()));
        }
        Page page = new Page();
        page.setTotal(searchs.getTotalHits());
        page.setRecords(crmBusinessLogEsEntities);
        return page;
    }

    private List<CrmBusinessLogEsVo> handleFiledTransformation(List<CrmBusinessLogEsVo> crmBusinessLogEsVos, String accessType, String parentCode) {
        ArrayList<FieldTransformVo> list = new ArrayList<FieldTransformVo>();
        if (CollectionUtils.isEmpty(this.crmBusinessLogStrategyServices)) {
            return crmBusinessLogEsVos;
        }
        for (CrmBusinessLogStrategyService crmBusinessLogStrategyService : this.crmBusinessLogStrategyServices) {
            String group = crmBusinessLogStrategyService.getTransformationCode();
            if (!StringUtils.equals((CharSequence)group, (CharSequence)accessType)) continue;
            list.addAll(crmBusinessLogStrategyService.handleTransformation(parentCode));
            break;
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (CrmBusinessLogEsVo crmBusinessLogEsVo : crmBusinessLogEsVos) {
                String s = LogTransform.fieldTransform(crmBusinessLogEsVo.getCompareResult(), list);
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                JSONObject jsonObject = JSON.parseObject((String)s);
                crmBusinessLogEsVo.setCompareResultJson(jsonObject);
            }
        }
        return crmBusinessLogEsVos;
    }
}

