/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.log.local.repository.CrmBusinessLogEsRepository;
import com.biz.crm.common.log.local.utils.CrmBusinessLogUtil;
import com.biz.crm.common.log.local.utils.LogCompare;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmBusinessLogVoServiceImpl
implements CrmBusinessLogVoService {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessLogVoServiceImpl.class);
    @Autowired(required=false)
    private CrmBusinessLogEsRepository crmBusinessLogRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Transactional
    public void handleSave(CrmBusinessLogDto crmBusinessLogDto) {
        Validate.notNull((Object)crmBusinessLogDto, (String)"\u4f20\u5165\u6bd4\u5bf9\u53c2\u6570\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)crmBusinessLogDto.getOperationType(), (String)"\u8bb0\u5f55\u4e1a\u52a1\u65e5\u5fd7\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)crmBusinessLogDto.getTenantCode(), (String)"\u8bb0\u5f55\u4e1a\u52a1\u65e5\u5fd7\u65f6\uff0c\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String operationType = crmBusinessLogDto.getOperationType();
        LoginDetails loginUser = this.loginUserService.getLoginUser();
        if (Objects.nonNull(loginUser)) {
            crmBusinessLogDto.setCreateAccount(loginUser.getAccount());
            crmBusinessLogDto.setCreateName(loginUser.getUsername());
            if (OperationTypeEunm.CREATE.getDictCode().equals(operationType)) {
                this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.voToEntityForAdd(crmBusinessLogDto));
            } else if (OperationTypeEunm.DELETE.getDictCode().equals(operationType)) {
                this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.voToEntityForDel(crmBusinessLogDto));
            } else {
                Object resullt = LogCompare.compareObject(JSON.toJSONString((Object)crmBusinessLogDto.getOldObject(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSON.toJSONString((Object)crmBusinessLogDto.getNewObject(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                this.crmBusinessLogRepository.save(CrmBusinessLogUtil.voToEntityForUpdate(crmBusinessLogDto, resullt));
            }
        }
    }
}

