package com.biz.crm.common.log.local.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

/**
 * @description: 业务日志es实体
 * @author: rentao
 * @date: 2022/5/10 11:36
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
@Document(indexName = "crmbusinesslog",createIndex=false)
public class CrmBusinessLogEsEntity {

  @Id
  private String id;

  @ApiModelProperty("操作类型")
  @Field(type = FieldType.Keyword)
  private String operationType;

  @ApiModelProperty("业务数据id")
  @Field(type = FieldType.Keyword)
  private String onlyKey;

  @ApiModelProperty("品牌商租户编号")
  @Field(type = FieldType.Keyword)
  private String appCode;

  @ApiModelProperty("租户")
  @Field(type = FieldType.Keyword)
  private String tenantCode;

  @ApiModelProperty("结果")
  @Field(type = FieldType.Text,index = false)
  private String compareResult;

  @ApiModelProperty("创建账号")
  @Field(type = FieldType.Keyword)
  private String createAccount;

  @ApiModelProperty("创建时间")
  @Field(type = FieldType.Keyword)
  private String createTime;

  @ApiModelProperty("创建人姓名")
  @Field(type = FieldType.Keyword)
  private String createName;

  @Field(type = FieldType.Long)
  private Long createTimeTimeNum;
}
