package com.biz.crm.common.log.local.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/**
 * @description: 日志字段替换工具类
 * @author: rentao
 * @date: 2022/5/23 19:21
 */
public class LogTransform {
  /**
   * 字段对比
   * @param jsonStr 替换json
   * @param list    字段名称集合
   * @author rentao
   * @date
   */
  public static String fieldTransform(String jsonStr, List<FieldTransformVo> list) {
    if(CollectionUtils.isEmpty(list) || StringUtils.isBlank(jsonStr)){
      return jsonStr;
    } else {
      Map<String, String> map = new HashMap<>();
      list.forEach(fieldTransformVo -> {
        map.put(fieldTransformVo.getFieldCode(), fieldTransformVo.getFieldName());
      });
      return oneTransform(JSON.parseObject(jsonStr), map).toString();
    }
  }

  private static JSONObject oneTransform(JSONObject oldJsonObject, Map<String, String> fieldMap) {
    JSONObject reJson = new JSONObject();
    Iterator<?> iter = oldJsonObject.keySet().iterator();
    //循环需要对比的字段
    while (iter.hasNext()) {
      String key = (String) iter.next();
      String fieldName;
      if (StringUtils.isEmpty(fieldMap.get(key))) {
        fieldName = key;
      } else {
        fieldName = fieldMap.get(key);
      }
      Object oldValue = oldJsonObject.get(key);
      if (oldValue instanceof JSONObject) {
        Object obj = oneTransform((JSONObject) oldValue, fieldMap);
        if (!ObjectUtils.isEmpty(obj)) {
          reJson.put(fieldName, obj);
        }
      } else if (oldValue instanceof JSONArray) {
        List<JSONObject> obj = manyTransform(JSON.parseArray(JSON.toJSONString(oldValue), JSONObject.class), fieldMap);
        if (!CollectionUtils.isEmpty(obj)) {
          reJson.put(fieldName, obj);
        }
      } else {
        reJson.put(fieldName, oldValue);
      }
    }
    return reJson;
  }

  /*
   *
   * 集合替换
   * @param oldJsonObjects
   * @param newJsonObjects
   * @author rentao
   * @date
   */
  private static List<JSONObject> manyTransform(List<JSONObject> oldJsonObjects, Map<String, String> fieldMap) {
    List<JSONObject> reList = new ArrayList<>();
    List<JSONObject> oldJsons = CollectionUtils.isEmpty(oldJsonObjects) ? new ArrayList<>() : oldJsonObjects;
    JSONObject result;
    Iterator<?> iterator = oldJsons.iterator();
    while (iterator.hasNext()) {
      JSONObject jsonObject = (JSONObject) iterator.next();
      result = oneTransform(jsonObject, fieldMap);
      if (result != null && !result.isEmpty()) {
        reList.add(result);
      }
    }
    return reList;
  }
}
