package com.biz.crm.common.log.local.config;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

/**
 * 获取Spring项目所有请求URL地址以及注解,主要用于项目测试使用。 在bootstrap文件中配置crm.show-rest-url=true即可开启该测试功能
 * 
 * @author Ken.xu
 *
 */
@Slf4j
@Component
public class ShowRestUrlLoader implements ApplicationContextAware {
  @Value("${crm.common.show-rest-url:false}")
  private boolean showRestUrl;

  @Override
  public void setApplicationContext(ApplicationContext ctx) throws BeansException {
    if (showRestUrl == false) {
      return;
    }
    System.out.println("加载RestController控制类清单");
    Map<String, Object> beans = ctx.getBeansWithAnnotation(RestController.class);
    StringBuilder sb = new StringBuilder();
    StringBuilder urlSb = new StringBuilder();
    for (String beanName : beans.keySet()) {

      Class<? extends Object> clazz = null;
      Object value = ctx.getBean(beanName);
      if (value == null) {
        continue;
      }
      clazz = value.getClass();
      String canonicalName = clazz.getCanonicalName();

      if (canonicalName.startsWith("com.bizunited.nebula")
          || canonicalName.startsWith("com.biz.crm.common")
          || canonicalName.contains(".deprecated.")) {
        continue;
      }

      // System.out.println(canonicalName);
      RequestMapping requestMapping = AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
      if (requestMapping == null) {
        continue;
      }
      String path = requestMapping.value()[0];
      Api api = AnnotationUtils.findAnnotation(clazz, Api.class);
      String description = "";
      if (api != null) {
        description = getFirstValue(api.tags()).replaceAll(",", "，");
      }
      
      urlSb.append("\n" + canonicalName + "," + path + "," + description);

      Method[] methods = clazz.getMethods();

//      log.info(">>> ", path);

      for (Method method : methods) {
        String url = "";
        String desc = "";

        // 每个方法必定含有下面的注解中的其中一个
        ApiOperation apiOperation = AnnotationUtils.findAnnotation(method, ApiOperation.class);
        if (apiOperation != null) {
          desc = apiOperation.value();
        }

        RequestMapping mapping = AnnotationUtils.findAnnotation(method, RequestMapping.class);
        PostMapping postMapping = AnnotationUtils.findAnnotation(method, PostMapping.class);
        GetMapping getMapping = AnnotationUtils.findAnnotation(method, GetMapping.class);
        PutMapping putMapping = AnnotationUtils.findAnnotation(method, PutMapping.class);
        DeleteMapping deleteMapping = AnnotationUtils.findAnnotation(method, DeleteMapping.class);
        if (postMapping != null) {
          url = path + getFirstValue(postMapping.value());
        } else if (getMapping != null) {
          url = path + getFirstValue(getMapping.value());
        } else if (putMapping != null) {
          url = path + getFirstValue(putMapping.value());
        } else if (deleteMapping != null) {
          url = path + getFirstValue(deleteMapping.value());
        } else if (mapping != null) { // mapping 顺序一定要在后面
          url = path + getFirstValue(mapping.value());
        } else {
          continue;
        }
        // url信息入库
        sb.append(String.format("\n%s,%s,%s", canonicalName, url, desc.replaceAll(",", "，")));
      }

    }
    
    System.out.println(urlSb);
    System.err.println("URL---CSV格式==== begin");
    System.err.println(sb);
    System.err.println("URL---CSV格式==== end");

  }

  private String getFirstValue(String[] value) {
    if (value.length > 0) {
      return value[0];
    } else {
      return "";
    }
  }
}
