package com.biz.crm.common.log.local.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/**
 * @description: 对多对比
 * @author: rentao
 * @date: 2022/5/10 14:11
 */
public class ManyConpare {

  //集合中唯一键
  private static final String ONLY_KEY = "id";
  //旧的数据标识
  private static final String OLD = "old";
  //新的数据标识
  private static final String NEW = "new";
  //新增提示
  private static final String ADD = "新增了：";
  //删除提示
  private static final String DELETE = "删除了：";


  /*
   * 集合对比
   * @param oldJsonObjects
   * @param newJsonObjects
   * @author rentao
   * @date
   */
  public static List<JSONObject> compare(List<JSONObject> oldJsonObjects,
      List<JSONObject> newJsonObjects) {
    List<JSONObject> reList = new ArrayList<>();
    //传入的旧数据
    List<JSONObject> oldJsons = CollectionUtils.isEmpty(oldJsonObjects) ? new ArrayList<>() : oldJsonObjects;
    //传入的旧数据
    List<JSONObject> newJsons = CollectionUtils.isEmpty(newJsonObjects) ? new ArrayList<>() : newJsonObjects;
    //需要对比的JSONObject集合
    Set<Map<String, JSONObject>> mapJSONObjectSet = new HashSet<>();
    //旧数据中id为空的
    List<JSONObject> listOld = transforToMapByOnlyKeyNull(oldJsons, ONLY_KEY);
    //新数据中id为空的
    List<JSONObject> listNew = transforToMapByOnlyKeyNull(newJsons, ONLY_KEY);
    //旧数据中id不为空的
    Map<String, JSONObject> oldJsonObjectMap = transforToMapByOnlyKeyNotNull(oldJsons, ONLY_KEY);
    //新数据中id不为空的
    Map<String, JSONObject> newJsonObjectMap = transforToMapByOnlyKeyNotNull(newJsons, ONLY_KEY);
    //迭代器
    Iterator iterator;
    //map entry
    Entry entry;
    //对比结果json
    JSONObject result;
    //提示
    StringBuilder promptStr;
    //提示信息json
    JSONObject promptJson;
    HashMap map;
    for (JSONObject jsonObject : listOld) {
      promptStr = new StringBuilder(DELETE);
      promptJson = new JSONObject();
      promptJson.put(promptStr.toString(), jsonObject);
      reList.add(promptJson);
    }
    for (JSONObject jsonObject : listNew) {
      promptStr = new StringBuilder(ADD);
      promptJson = new JSONObject();
      promptJson.put(promptStr.toString(), jsonObject);
      reList.add(promptJson);
    }
    if (!CollectionUtils.isEmpty(oldJsonObjects)) {
      iterator = oldJsonObjectMap.entrySet().iterator();
      while (iterator.hasNext()) {
        entry = (Entry) iterator.next();
        result = newJsonObjectMap.get(entry.getKey());
        if (null == result) {
          promptStr = new StringBuilder(DELETE);
          promptStr.append((String) entry.getKey());
          promptJson = new JSONObject();
          promptJson.put(promptStr.toString(), entry.getValue());
          reList.add(promptJson);
        } else {
          map = new HashMap();
          map.put(OLD, entry.getValue());
          map.put(NEW, result);
          mapJSONObjectSet.add(map);
        }
      }
    }
    if (!CollectionUtils.isEmpty(newJsonObjects)) {
      iterator = newJsonObjectMap.entrySet().iterator();
      while (iterator.hasNext()) {
        entry = (Entry) iterator.next();
        result = oldJsonObjectMap.get(entry.getKey());
        if (null == result) {
          promptStr = new StringBuilder(ADD);
          promptStr.append((String) entry.getKey());
          promptJson = new JSONObject();
          promptJson.put(promptStr.toString(), entry.getValue());
          reList.add(promptJson);
        } else {
          map = new HashMap();
          map.put(OLD, result);
          map.put(NEW, entry.getValue());
          mapJSONObjectSet.add(map);
        }
      }
    }
    if (CollectionUtils.isEmpty(mapJSONObjectSet)) {
      return reList;
    } else {
      iterator = mapJSONObjectSet.iterator();
      while (iterator.hasNext()) {
        Map<String, JSONObject> map1 = (Map) iterator.next();
        result = OneCompare.compare(map1.get(OLD), map1.get(NEW));
        if (result != null && !result.isEmpty()) {
          reList.add(result);
        }
      }
      return reList;
    }
  }

  public static String packageOnlykey(JSONObject value, String onlyKeyValue) {
    String[] keys = onlyKeyValue.split(",");
    StringBuilder onlyKey = new StringBuilder();
    String[] onlyKeys = keys;
    int length = keys.length;
    for (int i = 0; i < length; ++i) {
      String str = onlyKeys[i];
      Object obj = value.get(str);
      if (obj != null) {
        onlyKey.append(obj);
      }
    }
    return onlyKey.toString();
  }

  //这里需要把id不是空的全部取出来
  public static Map<String, JSONObject> transforToMapByOnlyKeyNotNull(List<JSONObject> jsonObjects,
      String onlyKeyValue) {
    if (CollectionUtils.isEmpty(jsonObjects)) {
      return new HashMap<>();
    } else {
      Map<String, JSONObject> reMap = new HashMap<>(jsonObjects.size());
      Iterator<?> iterator = jsonObjects.iterator();
      while (iterator.hasNext()) {
        JSONObject object = (JSONObject) iterator.next();
        if (!StringUtils.isEmpty(packageOnlykey(object, onlyKeyValue))) {
          reMap.put(packageOnlykey(object, onlyKeyValue), object);
        }
      }
      return reMap;
    }
  }


  //这里需要把id空的全部取出来
  public static List<JSONObject> transforToMapByOnlyKeyNull(List<JSONObject> jsonObjects, String onlyKeyValue) {
    if (CollectionUtils.isEmpty(jsonObjects)) {
      return new ArrayList<>();
    } else {
      List<JSONObject> arrayList = new ArrayList<>();
      Iterator<?> iterator = jsonObjects.iterator();
      while (iterator.hasNext()) {
        JSONObject object = (JSONObject) iterator.next();
        if (StringUtils.isEmpty(packageOnlykey(object, onlyKeyValue))) {
          arrayList.add(object);
        }
      }
      return arrayList;
    }
  }
}
