package com.biz.crm.common.log.local.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/**
 * @description: 一对一对比
 * @author: rentao
 * @date: 2022/5/10 14:09
 */
public class OneCompare {

  /**
   * 字段对比
   *
   * @param oldJsonObject 修改前json
   * @param newJsonObject 修改后json
   * @author rentao
   * @date
   */
  public static JSONObject compare(JSONObject oldJsonObject, JSONObject newJsonObject) {
    JSONObject reJson = new JSONObject();
    Iterator iter = oldJsonObject.keySet().iterator();
    newJsonObject = Optional.ofNullable(newJsonObject).orElse(new JSONObject());
    //循环需要对比的字段
    while (iter.hasNext()) {
      String key = (String) iter.next();
      //取出需要对比的字段
      Object oldValue = oldJsonObject.get(key);
      if (oldValue instanceof JSONObject) {
        Object newValue = newJsonObject.get(key);
        Object obj = compare((JSONObject) oldValue, (JSONObject) newValue);
        if (!ObjectUtils.isEmpty(obj)) {
          reJson.put(key, obj);
        }
      } else if (oldValue instanceof JSONArray) {
        Boolean b = true;
        JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(oldValue));
        for (Object o : jsonArray) {
          if (!(o instanceof JSONObject || o instanceof JSONArray)) {
            b = false;
          }
        }
        if (b) {
          Object newValue = Optional.ofNullable(newJsonObject.get(key)).orElse(new JSONArray());
          List<JSONObject> obj = ManyConpare
              .compare(JSON.parseArray(JSON.toJSONString(oldValue), JSONObject.class),
                  JSON.parseArray(JSON.toJSONString(newValue), JSONObject.class));
          if (!CollectionUtils.isEmpty(obj)) {
            reJson.put(key, obj);
          }
        } else {
          Object newValue = newJsonObject.get(key);
          //对基础属性 List<String> 类似直接对
          JSONObject jsonObject = compareList(JSON.parseArray(JSON.toJSONString(oldValue), Object.class),
              JSON.parseArray(JSON.toJSONString(newValue), Object.class));
          if (Objects.nonNull(jsonObject)) {
            reJson.put(key, jsonObject);
          }
        }
      } else {
        Object newValue = newJsonObject.get(key);
        Object obj = BasicTypeCompare.compare(oldValue, newValue);
        if (!Objects.isNull(obj)) {
          reJson.put(key, obj);
        }
      }
    }
    return reJson;
  }

  /**
   * 基础属性
   *
   * @param oldObject
   * @param newObject
   * @author rentao
   * @date
   */
  private static JSONObject compareList(List<Object> oldObject, List<Object> newObject) {
    JSONObject jsonObject = new JSONObject();
    if (CollectionUtils.isEmpty(oldObject) && CollectionUtils.isEmpty(oldObject)) {
      return null;
    }
    if (CollectionUtils.isEmpty(oldObject)) {
      jsonObject.put("新增了：", newObject);
    } else if (CollectionUtils.isEmpty(newObject)) {
      jsonObject.put("删除了：", newObject);
    } else {
      //
      List<Object> oldCompare = new ArrayList<>();
      oldCompare.addAll(oldObject);
      List<Object> newCompare = new ArrayList<>();
      newCompare.addAll(newObject);
      oldCompare.removeAll(newObject);
      newCompare.removeAll(oldObject);
      if (!CollectionUtils.isEmpty(oldCompare)) {
        jsonObject.put("删除了：", oldCompare);
      }
      if (!CollectionUtils.isEmpty(newCompare)) {
        jsonObject.put("新增了：", newCompare);
      }
      if (CollectionUtils.isEmpty(oldCompare) && CollectionUtils.isEmpty(newCompare)) {
        return null;
      }
    }
    return jsonObject;
  }

}
