package com.biz.crm.common.log.local.model;

import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import lombok.Getter;
import lombok.Setter;

/**
 * @author ning.zhang
 * @description 字段转换模版类
 * @date 2025/06/04
 */
@Getter
@Setter
public class FieldTransformModel {

  /**
   * 数据所属功能字段映射(key:菜单编码-字段, value:字段信息)
   */
  private Map<String, FieldTransformVo> functionFieldTransformMap = Maps.newHashMap();

  /**
   * 默认菜单(前端传递的菜单)字段映射(key:字段, value:字段信息)
   */
  private Map<String, FieldTransformVo> defaultFunctionFieldTransformMap = Maps.newHashMap();

  /**
   * 系统配置(如数据字典中配置的)的字段映射(key:字段, value:字段信息)
   */
  private Map<String, FieldTransformVo> defaultFieldTransformMap = Maps.newHashMap();

  /**
   * 待转换数据中的菜单编码
   */
  private String parentCode;

  /**
   * 菜单名称
   */
  private String parentName;

  /**
   * 待转换数据中的功能编码
   */
  private String functionCode;
}
