package com.biz.crm.common.log.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.log.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.local.model.FieldTransformModel;
import com.biz.crm.common.log.local.service.CrmBusinessLogService;
import com.biz.crm.common.log.local.utils.LogTransform;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogQueryDto;
import com.biz.crm.common.log.sdk.dto.FieldTransformDto;
import com.biz.crm.common.log.sdk.strategy.CrmBusinessLogStrategy;
import com.biz.crm.common.log.sdk.utils.EsUtil;
import com.biz.crm.common.log.sdk.vo.CrmBusinessLogEsVo;
import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 业务日志service
 * @author: rentao
 * @date: 2022/5/10 15:06
 */
@Service
public class CrmBusinessLogServiceImpl implements CrmBusinessLogService {

  @Autowired
  private ElasticsearchRestTemplate elasticsearchRestTemplate;
  @Autowired(required = false)
  private List<CrmBusinessLogStrategy> crmBusinessLogStrategyServices;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<CrmBusinessLogEsVo> findByConditions(Pageable pageable, CrmBusinessLogQueryDto crmBusinessLogDto) {
     crmBusinessLogDto = Optional.ofNullable(crmBusinessLogDto).orElse(new CrmBusinessLogQueryDto());
//    Validate.notNull(crmBusinessLogDto, "查询日志参数不能为空");
//    Validate.notBlank(crmBusinessLogDto.getOnlyKey(), "查询日志,业务id不能为空");
//    Validate.notBlank(crmBusinessLogDto.getAccessType(), "查询日志,获取方式不能为空");
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    if (!EsUtil.indexExsitNoCreate(this.elasticsearchRestTemplate, CrmBusinessLogEsEntity.class)) {
      return null;
    } else {
//      BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
//      //onlyKey + 菜单编码确定唯一
//      boolQueryBuilder
//          .must(QueryBuilders.termQuery("onlyKey.keyword", crmBusinessLogDto.getOnlyKey()));
//      boolQueryBuilder.must(QueryBuilders.termQuery("appCode.keyword", TenantUtils.getTenantCode()));
//      boolQueryBuilder
//          .must(QueryBuilders.termQuery("tenantCode.keyword", TenantUtils.getTenantCode()));
      BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
      //onlyKey + 菜单编码确定唯一
      if (StringUtils.isNotBlank(crmBusinessLogDto.getOnlyKey())) {
        boolQueryBuilder
            .must(QueryBuilders.termQuery("onlyKey", crmBusinessLogDto.getOnlyKey()));
      }
      if (StringUtils.isNotBlank(crmBusinessLogDto.getAppCode())) {
        boolQueryBuilder.must(QueryBuilders.termQuery("appCode", TenantUtils.getTenantCode()));
      }
      if (StringUtils.isNotBlank(crmBusinessLogDto.getSearchParentCode())) {
        boolQueryBuilder.must(QueryBuilders.termQuery("parentCode", crmBusinessLogDto.getSearchParentCode()));
      }
      if( StringUtils.isNotBlank(crmBusinessLogDto.getTenantCode())) {
        boolQueryBuilder
            .must(QueryBuilders.termQuery("tenantCode", TenantUtils.getTenantCode()));
      }
      if (StringUtils.isNotBlank(crmBusinessLogDto.getOperationType())) {
        boolQueryBuilder.must(
            QueryBuilders.termQuery("operationType", crmBusinessLogDto.getOperationType()));
      }
      if (StringUtils.isNotBlank(crmBusinessLogDto.getCreateAccount())) {
        boolQueryBuilder.must(QueryBuilders.termQuery("createAccount", crmBusinessLogDto.getCreateAccount()));
      }
      if (StringUtils.isNotBlank(crmBusinessLogDto.getCreateName())) {
        boolQueryBuilder.must(QueryBuilders.wildcardQuery("createName", "*".concat(crmBusinessLogDto.getCreateName()).concat("*")));
      }
      NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(boolQueryBuilder)
          .withSorts(SortBuilders.fieldSort("createTimeTimeNum").order(SortOrder.DESC))
          .withPageable(PageRequest.of(pageable.getPageNumber() - 1, pageable.getPageSize()))
          .build();
      SearchHits<CrmBusinessLogEsEntity> searchs = this.elasticsearchRestTemplate.search(searchQuery, CrmBusinessLogEsEntity.class);
      List<CrmBusinessLogEsEntity> crmLogEntityList = searchs.get().map(SearchHit::getContent).collect(Collectors.toList());
      List<CrmBusinessLogEsVo> crmBusinessLogEsEntities = Lists.newArrayList();
      Page<CrmBusinessLogEsVo> page = new Page<>();
      page.setTotal(searchs.getTotalHits());
      page.setCurrent(pageable.getPageNumber());
      if (CollectionUtils.isEmpty(crmLogEntityList)) {
        return page;
      }
      List<CrmBusinessLogEsVo> crmBusinessLogEsVoList = (List<CrmBusinessLogEsVo>) this.nebulaToolkitService.copyCollectionByBlankList(crmLogEntityList, CrmBusinessLogEsEntity.class,CrmBusinessLogEsVo.class, HashSet.class, ArrayList.class);
      //需要转换成汉字
      crmBusinessLogEsEntities.addAll(this.handleFiledTransformation(crmBusinessLogEsVoList, crmBusinessLogDto));
      page.setRecords(crmBusinessLogEsEntities);
      return page;
    }
  }

  private List<CrmBusinessLogEsVo> handleFiledTransformation(List<CrmBusinessLogEsVo> crmBusinessLogEsVos, CrmBusinessLogQueryDto dto) {
    if (CollectionUtils.isEmpty(crmBusinessLogStrategyServices)) {
      return crmBusinessLogEsVos;
    }

    Set<String> parentCodes = Sets.newHashSet(dto.getParentCode());
    for (CrmBusinessLogEsVo crmBusinessLogEsVo : crmBusinessLogEsVos) {
      parentCodes.add(crmBusinessLogEsVo.getParentCode());
    }
    parentCodes = parentCodes.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    FieldTransformDto dataTransformDto = new FieldTransformDto();
    dataTransformDto.setParentCodes(parentCodes);

    FieldTransformModel transformModel = new FieldTransformModel();
    List<FieldTransformVo> transformList = Lists.newArrayList();
    for (CrmBusinessLogStrategy crmBusinessLogStrategyService : crmBusinessLogStrategyServices) {
      transformList.addAll(crmBusinessLogStrategyService.handleTransformation(dataTransformDto));
    }
    // 获取系统配置(如数据字典中配置的)配置字段信息
    transformModel.setDefaultFieldTransformMap(transformList.stream()
        .filter(transformVo -> Boolean.TRUE.equals(transformVo.getIsDefault()))
        .collect(Collectors.toMap(FieldTransformVo::getFieldCode, Function.identity(), (a, b) -> a)));
    // 获取数据中对应的菜单功能对应的配置字段信息
    transformModel.setFunctionFieldTransformMap(transformList.stream()
        .filter(transformVo -> !Boolean.TRUE.equals(transformVo.getIsDefault()))
        .collect(Collectors.toMap(transformVo -> String.format("%s-%s", transformVo.getParentCode(), transformVo.getFieldCode()), Function.identity(), (a, b) -> a)));

    if (StringUtils.isNotBlank(dto.getParentCode())) {
      // 获取页面传递的菜单的配置字段信息
      transformModel.setDefaultFunctionFieldTransformMap(transformList.stream().filter(transformVo -> dto.getParentCode().equals(transformVo.getParentCode()))
          .collect(Collectors.toMap(FieldTransformVo::getFieldCode, Function.identity(), (a, b) -> a)));
    }

    Map<String, String> parentNameMap = transformList.stream()
        .filter(transformVo -> StringUtils.isNotBlank(transformVo.getParentCode()) && StringUtils.isNotBlank(transformVo.getParentName()))
        .collect(Collectors.toMap(FieldTransformVo::getParentCode, FieldTransformVo::getParentName,(a, b) -> a));

    for (CrmBusinessLogEsVo crmBusinessLogEsVo : crmBusinessLogEsVos) {
      transformModel.setParentCode(crmBusinessLogEsVo.getParentCode());
      crmBusinessLogEsVo.setParentName(parentNameMap.get(crmBusinessLogEsVo.getParentCode()));
      String s = LogTransform.fieldTransform(crmBusinessLogEsVo, transformModel);
      if (StringUtils.isNotBlank(s)) {
        JSONObject jsonObject = JSON.parseObject(s);
        crmBusinessLogEsVo.setCompareResultJson(jsonObject);
      }
    }
    return crmBusinessLogEsVos;
  }

}


