package com.biz.crm.common.log.local.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.local.model.FieldTransformModel;
import com.biz.crm.common.log.sdk.vo.CrmBusinessLogEsVo;
import com.biz.crm.common.log.sdk.vo.DictDataTransformVo;
import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @description: 日志字段替换工具类
 * @author: rentao
 * @date: 2022/5/23 19:21
 */
public class LogTransform {
  /**
   * 字段对比
   * @param crmBusinessLogEsVo log信息
   * @param transformModel  字段转换信息
   * @author rentao
   * @date
   */
  public static String fieldTransform(CrmBusinessLogEsVo crmBusinessLogEsVo, FieldTransformModel transformModel) {
    String jsonStr = crmBusinessLogEsVo.getCompareResult();
    if(StringUtils.isBlank(jsonStr)){
      return jsonStr;
    }

    return oneTransform(crmBusinessLogEsVo, JSON.parseObject(jsonStr), transformModel).toString();
  }

  private static JSONObject oneTransform(CrmBusinessLogEsVo crmBusinessLogEsVo, JSONObject oldJsonObject, FieldTransformModel transformModel) {
    Map<String, FieldTransformVo> defaultFunctionFieldTransformMap = transformModel.getDefaultFunctionFieldTransformMap();
    Map<String, FieldTransformVo> functionFieldTransformMap = transformModel.getFunctionFieldTransformMap();
    Map<String, FieldTransformVo> defaultFieldTransformMap = transformModel.getDefaultFieldTransformMap();
    String parentCode = transformModel.getParentCode();
    JSONObject reJson = new JSONObject();
    Iterator<?> iter = oldJsonObject.keySet().iterator();
    //循环需要对比的字段
    while (iter.hasNext()) {
      String key = (String) iter.next();
      FieldTransformVo fieldTransform = functionFieldTransformMap.get(String.format("%s-%s", parentCode, key));
      if (Objects.isNull(fieldTransform)) {
        fieldTransform = defaultFunctionFieldTransformMap.get(key);
      }
      if (Objects.isNull(fieldTransform)) {
        fieldTransform = defaultFieldTransformMap.get(key);
      }
      String fieldName = Objects.isNull(fieldTransform) ? key : fieldTransform.getFieldName();
      Object oldValue = oldJsonObject.get(key);
      if (oldValue instanceof JSONObject) {
        Object obj = oneTransform(crmBusinessLogEsVo, (JSONObject) oldValue, transformModel);
        if (!ObjectUtils.isEmpty(obj)) {
          reJson.put(fieldName, obj);
        }
      } else if (oldValue instanceof JSONArray) {
        try {
          List<JSONObject> obj = manyTransform(crmBusinessLogEsVo, JSON.parseArray(JSON.toJSONString(oldValue), JSONObject.class), transformModel);
          if (!CollectionUtils.isEmpty(obj)) {
            reJson.put(fieldName, obj);
          }
        }catch (Exception e){
          reJson.put(fieldName,oldValue);
        }
      } else if (oldValue instanceof String && Objects.nonNull(fieldTransform) && CollectionUtils.isNotEmpty(fieldTransform.getDictDataList())){
        // 解析出封装前后的字典
        String[] splitValues = ((String) oldValue).replace("】", "").replace("【", "").split(" ---> ");
        String transValue = (String) oldValue;
        if (splitValues.length == 2) {
          Map<String, String> dictMap = fieldTransform.getDictDataList().stream().collect(Collectors.toMap(DictDataTransformVo::getDictCode, DictDataTransformVo::getDictValue, (a, b) -> a));
          transValue = String.format("【%s  ---> %s】", dictMap.getOrDefault(splitValues[0], splitValues[0]), dictMap.getOrDefault(splitValues[1], splitValues[1]));
        }
        reJson.put(fieldName, transValue);
      } else {
        reJson.put(fieldName, oldValue);
      }
    }
    return reJson;
  }

  /*
   *
   * 集合替换
   * @param oldJsonObjects
   * @param newJsonObjects
   * @author rentao
   * @date
   */
  private static List<JSONObject> manyTransform(CrmBusinessLogEsVo crmBusinessLogEsVo, List<JSONObject> oldJsonObjects, FieldTransformModel transformModel) {
    List<JSONObject> reList = new ArrayList<>();
    List<JSONObject> oldJsons = CollectionUtils.isEmpty(oldJsonObjects) ? new ArrayList<>() : oldJsonObjects;
    JSONObject result;
    Iterator<?> iterator = oldJsons.iterator();
    while (iterator.hasNext()) {
      JSONObject jsonObject = (JSONObject) iterator.next();
      result = oneTransform(crmBusinessLogEsVo, jsonObject, transformModel);
      if (result != null && !result.isEmpty()) {
        reList.add(result);
      }
    }
    return reList;
  }
}
