package com.biz.crm.common.log.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 业务日志保存dto
 * @author: rentao
 * @date: 2022/5/10 11:27
 */
@Data
@ApiModel(value = "CrmBusinessLogDto", description = "业务日志保存dto")
public class CrmBusinessLogDto{

  /**
   * 操作类型
   */
  @ApiModelProperty("操作类型")
  private String  operationType;

  /**
   * 业务数据id
   */
  @ApiModelProperty("业务数据id")
  private String onlyKey;

  /**
   * 品牌商租户编号
   */
  @ApiModelProperty(name = "appCode", value = "品牌商租户编号")
  private String appCode;

  /**
   * 租户
   */
  @ApiModelProperty("租户")
  private String tenantCode;

  /**
   * 旧对象
   */
  @ApiModelProperty("旧对象")
  private Object oldObject;

  /**
   * 新对象
   */
  @ApiModelProperty("新对象")
  private Object newObject;

  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", value = "创建人账号")
  private String createAccount;

  /**
   * 创建人名称
   */
  @ApiModelProperty(name = "createName", value = "创建人名称")
  private String createName;

}
