package com.biz.crm.common.log.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @description: 业务日志查询dto
 * @author: rentao
 * @date: 2022/5/23 11:12
 */
@Data
@ApiModel(value = "CrmBusinessLogDto", description = "业务日志查询dto")
public class CrmBusinessLogQueryDto {

  /**
   * 操作类型
   */
  @ApiModelProperty("操作类型")
  private String  operationType;

  /**
   * 业务数据id
   */
  @ApiModelProperty("业务数据id")
  private String onlyKey;

  /**
   * 品牌商租户编号
   */
  @ApiModelProperty(name = "appCode", value = "品牌商租户编号")
  private String appCode;

  /**
   * 租户
   */
  @ApiModelProperty("租户")
  private String tenantCode;

  /**
   * 上级菜单
   */
  @ApiModelProperty("上级菜单")
  private String parentCode;

  /**
   * 页面引擎主表
   */
  @ApiModelProperty("页面引擎主表")
  private String functionCode;

  /**
   * 获取方式（此参数固定拿的是 CrmBusinessLogStrategyService 实现类里面的code）
   */
  @ApiModelProperty("获取方式（此参数固定拿的是 CrmBusinessLogStrategyService 实现类里面的code)")
  private String accessType;

}
