package com.biz.crm.common.log.sdk.strategy;

import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import java.util.List;

/**
 * @description: 业务日志获取属性与属性名称接口 项目上可以通过次策略实现获取方式
 * @author: rentao
 * @date: 2022/5/20 16:10
 */
public interface CrmBusinessLogStrategy {

  /**
   * 获取方式的名称  例如：表单引擎获取
   * @author rentao
   * @date
   */
  String getTransformationName();

  /**
   * 获取方式的编码 此编码需要自己定义 却需要保证 实现此接口中编码唯一
   * 因为查询日志后 需要通过前端传入的 accessType 获取方式编码取做匹配
   * @author rentao
   * @date
   */
  String getTransformationCode();

  /**
   * 通过获取方式查询出的 属性对应属性名称集合
   * @param parentCode  通过此编码取获取 属性对应属性名称集合  前端通过 com.biz.crm.common.log.sdk.dto.CrmBusinessLogQueryDto 传入
   * @author rentao
   * @date
   */
  List<FieldTransformVo> handleTransformation(String parentCode);

}
