package com.biz.crm.common.log.sdk.utils;

import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

/**
 * @description: es自定义工具
 * @author: rentao
 * @date: 2022/5/9 15:22
 */
public class EsUtil {

  private static final ConcurrentHashMap<String, Object> indexMap = new ConcurrentHashMap<>();

  private static final Object obj = new Object();

  //ES创建索引锁
  private static final String INDEX_LOCK = "ES_CREATE_INDEX";

  /**
   * 验证索引 注：没有查到索引则创建索引
   * </br>
   *
   * @param elasticsearchTemplate
   * @param clazz
   * @param redisMutexService
   * @author rentao
   * @date
   */
  public static boolean indexExsit(ElasticsearchRestTemplate elasticsearchTemplate, Class<?> clazz,
      RedisMutexService redisMutexService) {
    if (indexMap.containsKey(clazz.getName())) {
      return true;
    } else if (elasticsearchTemplate.indexOps(clazz).exists()) {
      indexMap.put(clazz.getName(), obj);
      return true;
    } else {
      boolean isLock = false;
      try {
        if (isLock = redisMutexService.tryLock(INDEX_LOCK, TimeUnit.MILLISECONDS, 10)) {
          elasticsearchTemplate.indexOps(clazz).create();
          indexMap.put(clazz.getName(), obj);
        } else {
          throw new IllegalArgumentException("加锁失败!!");
        }
      } finally {
        if (isLock) {
          redisMutexService.unlock(INDEX_LOCK);
        }
      }
      return false;
    }
  }


  /**
   * 验证索引（不会创建索引）
   *
   * @param elasticsearchTemplate
   * @param clazz
   * @author rentao
   * @date
   */
  public static boolean indexExsitNoCreate(ElasticsearchRestTemplate elasticsearchTemplate,
      Class<?> clazz) {
    if (indexMap.containsKey(clazz.getName())) {
      return true;
    } else if (elasticsearchTemplate.indexOps(clazz).exists()) {
      indexMap.put(clazz.getName(), obj);
      return true;
    } else {
      return false;
    }
  }

}
