package com.biz.crm.common.log.sdk.enums;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 操作类型枚举
 * @author: rentao
 * @date: 2022/5/13 14:45
 */
@Getter
@AllArgsConstructor
public enum OperationTypeEunm {

  /**
   * 新增
   */
  CREATE("create", "create", "新增", "1"),
  /**
   * 编辑
   */
  UPDATE("update", "update", "编辑", "2"),
  /**
   * 删除
   */
  DELETE("delete", "delete", "删除", "3"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static OperationTypeEunm findByCode(String code) {
    Optional<OperationTypeEunm> first = Stream.of(OperationTypeEunm.values())
        .filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}