package com.biz.crm.common.log.sdk.enums;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 对比的字段类型 支持 基础类型 自定义对象 集合
 * @author: rentao
 * @date: 2022/5/13 20:02
 */
@Getter
@AllArgsConstructor
public enum HostTypeEnum {

  /**
   * 新增
   */
  BASICS_TYPE("basics_type", "basics_type", "基础类型", "1"),
  /**
   * 编辑
   */
  OBJECT_TYPE("object_type", "object_type", "对象", "2"),
  /**
   * 删除
   */
  COLLECTION_TYPE("collection_type", "collection_type", "集合", "3"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static HostTypeEnum findByCode(String code) {
    Optional<HostTypeEnum> first = Stream.of(HostTypeEnum.values())
        .filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}
