package com.biz.crm.common.log.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

/**
 * @description: 业务日志查询dto
 * @author: rentao
 * @date: 2022/5/23 11:12
 */
@Data
@ApiModel(value = "CrmBusinessLogDto", description = "业务日志查询dto")
public class CrmBusinessLogQueryDto {

  /**
   * 操作类型
   */
  @ApiModelProperty("操作类型")
  private String  operationType;

  /**
   * 业务数据id
   */
  @ApiModelProperty("业务数据id")
  private String onlyKey;

  /**
   * 品牌商租户编号
   */
  @ApiModelProperty(name = "appCode", value = "品牌商租户编号")
  private String appCode;

  /**
   * 租户
   */
  @ApiModelProperty("租户")
  private String tenantCode;

  /**
   * 获取属性属性名称的编码
   */
  @ApiModelProperty("获取属性属性名称的编码")
  private String parentCode;

  /**
   * 页面引擎主表
   */
  @ApiModelProperty("页面引擎主表")
  private String functionCode;

  /**
   * 搜索使用的菜单编码
   */
  @ApiModelProperty("搜索使用的菜单编码")
  private String searchParentCode;

  /**
   * 获取方式（此参数固定拿的是 CrmBusinessLogStrategyService 实现类里面的code）
   */
  @Deprecated
  @ApiModelProperty("获取方式（此参数固定拿的是 CrmBusinessLogStrategyService 实现类里面的code)")
  private String accessType;

  /**
   * 创建账号
   */
  @ApiModelProperty("创建账号")
  private String createAccount;

  /**
   * 创建人姓名
   */
  @ApiModelProperty("创建人姓名")
  private String createName;

}
