/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.logicdelete.local;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.biz.crm.common.logicdelete.sdk.IgnoreLogicDelete;
import com.biz.crm.common.logicdelete.sdk.LogicDelete;
import com.biz.crm.common.logicdelete.sdk.LogicDeleteModel;
import com.biz.crm.common.logicdelete.sdk.SqlTableInfo;
import com.biz.crm.common.logicdelete.sdk.config.LogicDeleteProperties;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class SqlInfoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlInfoParser.class);
    private EntityManager entityManager;
    private LogicDeleteProperties logicDeleteProperties;
    private DbType dbType = DbType.mysql;
    private String sql;

    public SqlInfoParser(EntityManager entityManager, LogicDeleteProperties logicDeleteProperties, String sql) {
        this.entityManager = entityManager;
        this.logicDeleteProperties = logicDeleteProperties;
        this.sql = sql;
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)this.dbType);
        List stmtList = parser.parseStatementList();
        if (CollectionUtils.isEmpty((Collection)stmtList)) {
            return;
        }
        SQLStatement stmt = (SQLStatement)stmtList.get(0);
        if (stmt instanceof SQLDeleteStatement) {
            SQLDeleteStatement deleteStmt = (SQLDeleteStatement)stmt;
            this.deleteParser(deleteStmt);
        } else if (stmt instanceof SQLSelectStatement) {
            SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
            this.selectParser(selectStmt);
        } else if (stmt instanceof SQLUpdateStatement) {
            SQLUpdateStatement updateStmt = (SQLUpdateStatement)stmt;
            this.updateParser(updateStmt);
        } else if (stmt instanceof SQLInsertStatement) {
            SQLInsertStatement sQLInsertStatement = (SQLInsertStatement)stmt;
        }
    }

    private void insertParser(SQLInsertStatement insertStatement) {
        LOGGER.debug("insertStatement");
    }

    private void selectParser(SQLSelectStatement selectStatement) {
        LOGGER.debug("selectStatement");
        SQLSelect sqlselect = selectStatement.getSelect();
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)sqlselect.getQuery();
        if (query != null && query.getFrom() != null) {
            SqlTableInfo jpaSqlInfo = this.getFrom(query.getFrom());
            if (jpaSqlInfo == null) {
                return;
            }
            if (!jpaSqlInfo.isLogicDelete()) {
                return;
            }
            if (jpaSqlInfo != null) {
                StringBuffer whereSql = new StringBuffer();
                if (StringUtils.hasText((String)jpaSqlInfo.getTableAlias())) {
                    whereSql.append(jpaSqlInfo.getTableAlias());
                    whereSql.append(".");
                }
                whereSql.append(this.logicDeleteProperties.getDelFiled());
                whereSql.append(" = ");
                whereSql.append(this.logicDeleteProperties.getNotDelValue());
                SQLExpr expr = new SQLExprParser(whereSql.toString(), this.dbType, new SQLParserFeature[0]).expr();
                query.addWhere(expr);
            }
        }
        this.sql = selectStatement.toString();
    }

    private void updateParser(SQLUpdateStatement updateStatement) {
        LOGGER.debug("updateStatement");
    }

    private void deleteParser(SQLDeleteStatement deleteStatement) {
        LOGGER.debug("deleteStatement,redo sql with update");
        StringBuffer buf = new StringBuffer();
        buf.append("UPDATE ");
        deleteStatement.getTableSource().output(buf);
        buf.append(" SET ");
        SqlTableInfo jpaSqlInfo = this.getFrom(deleteStatement.getTableSource());
        if (jpaSqlInfo == null) {
            return;
        }
        if (!jpaSqlInfo.isLogicDelete()) {
            return;
        }
        if (jpaSqlInfo != null) {
            StringBuffer whereSql = new StringBuffer();
            if (StringUtils.hasText((String)jpaSqlInfo.getTableAlias())) {
                whereSql.append(jpaSqlInfo.getTableAlias());
                whereSql.append(".");
            }
            whereSql.append(this.logicDeleteProperties.getDelFiled());
            whereSql.append(" = ");
            whereSql.append(this.logicDeleteProperties.getDelValue());
            buf.append(whereSql);
        }
        if (deleteStatement.getWhere() != null) {
            buf.append(" WHERE ");
            SQLExpr opExpr = deleteStatement.getWhere();
            buf.append(SQLUtils.toSQLString((SQLObject)opExpr));
        }
        this.sql = buf.toString();
    }

    private SqlTableInfo getFrom(SQLTableSource tableFrom) {
        if (tableFrom == null) {
            return null;
        }
        SqlTableInfo sqlTableInfo = new SqlTableInfo();
        if (tableFrom instanceof SQLExprTableSource) {
            SQLExprTableSource tableSource = (SQLExprTableSource)tableFrom;
            sqlTableInfo.setTableName(tableSource.getTableName());
            sqlTableInfo.setTableAlias(tableSource.getAlias());
            sqlTableInfo.setEntityClass(this.findEntityClass(sqlTableInfo.getTableName()));
            sqlTableInfo.setLogicDelete(this.needLogicDelete(sqlTableInfo.getEntityClass()).booleanValue());
            if (sqlTableInfo.isLogicDelete() && !this.checkLogicDeleteFiled(sqlTableInfo.getEntityClass()).booleanValue()) {
                Validate.isTrue((!BooleanUtils.toBooleanDefaultIfNull((Boolean)this.logicDeleteProperties.getEnforce(), (boolean)true) ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5b9e\u4f53\u3010%s\u3011\u4e2d\u5fc5\u987b\u5b58\u5728\u5220\u9664\u6807\u8bc6\u5b57\u6bb5\uff01", (Object[])new Object[]{sqlTableInfo.getEntityClass().getName()});
                LOGGER.warn("\u903b\u8f91\u5220\u9664\u5931\u8d25\uff0c\u8be5\u5b9e\u4f53\u4e0d\u5b58\u5728\u903b\u8f91\u5220\u9664\u6807\u8bc6\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5 \u8868\u3010{}\u3011,\u5b9e\u4f53\u3010{}\u3011", (Object)sqlTableInfo.getTableName(), (Object)sqlTableInfo.getEntityClass().getName());
            }
            return sqlTableInfo;
        }
        if (tableFrom instanceof SQLJoinTableSource) {
            SQLJoinTableSource tableSource = (SQLJoinTableSource)tableFrom;
            SQLJoinTableSource.JoinType joinType = tableSource.getJoinType();
            switch (joinType) {
                case RIGHT_OUTER_JOIN: {
                    SQLTableSource rightTableSource = tableSource.getRight();
                    return this.getFrom(rightTableSource);
                }
            }
            SQLTableSource leftTableSource = tableSource.getLeft();
            return this.getFrom(leftTableSource);
        }
        if (tableFrom instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource tableSource = (SQLSubqueryTableSource)tableFrom;
            SQLSelectQueryBlock subQuery = (SQLSelectQueryBlock)tableSource.getSelect().getQuery();
            return this.getFrom(subQuery.getFrom());
        }
        if (tableFrom instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource sQLUnionQueryTableSource = (SQLUnionQueryTableSource)tableFrom;
        }
        LOGGER.warn("\u672a\u627e\u5230\u5408\u9002\u7684\u5904\u7406\u6d41\u7a0b[{}]", tableFrom.getClass());
        return null;
    }

    private Class<?> findEntityClass(String tableName) {
        EntityManagerFactory entityManagerFactory = this.entityManager.getEntityManagerFactory();
        MetamodelImplementor metamodel = (MetamodelImplementor)entityManagerFactory.getMetamodel();
        Map persistentMap = metamodel.entityPersisters();
        for (Map.Entry entity : persistentMap.entrySet()) {
            SingleTableEntityPersister persistent = (SingleTableEntityPersister)entity.getValue();
            String name = persistent.getTableName();
            name = StringUtils.deleteAny((String)name, (String)"`");
            if (!(tableName = StringUtils.deleteAny((String)tableName, (String)"`")).equals(name)) continue;
            return persistent.getMappedClass();
        }
        return null;
    }

    private Boolean needLogicDelete(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        LogicDeleteModel logicDeleteModel = LogicDeleteModel.get((String)this.logicDeleteProperties.getModel());
        if (logicDeleteModel == null) {
            logicDeleteModel = LogicDeleteModel.WHITE;
        }
        if (logicDeleteModel == LogicDeleteModel.WHITE) {
            LogicDelete logicDelete = clazz.getAnnotation(LogicDelete.class);
            if (logicDelete != null) {
                return true;
            }
            return false;
        }
        IgnoreLogicDelete ignoreLogicDelete = clazz.getAnnotation(IgnoreLogicDelete.class);
        if (ignoreLogicDelete != null) {
            return false;
        }
        return true;
    }

    private Boolean checkLogicDeleteFiled(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        ArrayList fieldList = Lists.newArrayList();
        while (clazz != null) {
            fieldList.addAll(Lists.newArrayList((Object[])clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        Set fields = fieldList.stream().filter(item -> {
            Column column = item.getAnnotation(Column.class);
            return column != null;
        }).map(item -> {
            Column column = item.getAnnotation(Column.class);
            return column.name();
        }).collect(Collectors.toSet());
        if (fields.contains(this.logicDeleteProperties.getDelFiled())) {
            return true;
        }
        return false;
    }

    public String getSql() {
        return this.sql;
    }
}

