/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.logicdelete.local.interceptor;

import com.biz.crm.common.logicdelete.local.utils.SpringBeanUtils;
import com.biz.crm.common.logicdelete.sdk.listener.JpaListener;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.EmptyInterceptor;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class JpaInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 2322192075061736168L;

    public String onPrepareStatement(String sql) {
        return super.onPrepareStatement(this.processSql(sql));
    }

    private String processSql(String sql) {
        Map jpaListenerMap = SpringBeanUtils.applicationContext.getBeansOfType(JpaListener.class);
        if (CollectionUtils.isEmpty((Map)jpaListenerMap)) {
            return sql;
        }
        ArrayList jpaListeners = Lists.newArrayList(jpaListenerMap.values());
        AtomicReference<String> result = new AtomicReference<String>(sql);
        jpaListeners.stream().sorted(Comparator.comparing(Ordered::getOrder)).forEach(listener -> result.set(listener.process((String)result.get())));
        return result.get();
    }
}

