/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.logicdelete.local.listener;

import com.biz.crm.common.logicdelete.local.SqlInfoParser;
import com.biz.crm.common.logicdelete.sdk.config.LogicDeleteProperties;
import com.biz.crm.common.logicdelete.sdk.context.LogicDeleteContextHolder;
import com.biz.crm.common.logicdelete.sdk.listener.JpaListener;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HqlLogicDeleteListener
implements JpaListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HqlLogicDeleteListener.class);
    private final LogicDeleteProperties logicDeleteProperties;
    private EntityManager entityManager;

    public HqlLogicDeleteListener(EntityManager entityManager, LogicDeleteProperties logicDeleteProperties) {
        LOGGER.info("*** \u542f\u7528\u903b\u8f91\u5220\u9664\u529f\u80fd ***");
        this.entityManager = entityManager;
        this.logicDeleteProperties = logicDeleteProperties;
    }

    public String process(String sql) {
        Boolean ignoreLogicDelete = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)LogicDeleteContextHolder.get((String)"_ignoreLogicDelete")), (boolean)false);
        if (ignoreLogicDelete.booleanValue()) {
            return sql;
        }
        SqlInfoParser jpaSqlPaser = new SqlInfoParser(this.entityManager, this.logicDeleteProperties, sql);
        return jpaSqlPaser.getSql();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

