package com.biz.crm.common.message.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.feign.feign.SendMessageVoServiceFeign;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 消息feign实现
 *
 * @author sunx
 * @date 2022/7/5
 */
@Component
public class SendMessageVoServiceFeignImpl implements FallbackFactory<SendMessageVoServiceFeign> {

  @Override
  public SendMessageVoServiceFeign create(Throwable throwable) {
    return new SendMessageVoServiceFeign() {
      @Override
      public Result<?> send(SysMessageDto dto) {
        throw new UnsupportedOperationException("发送系统消息熔断");
      }

      @Override
      public Result<?> sendBatch(List<SysMessageDto> list) {
        throw new UnsupportedOperationException("批量发送系统消息熔断");
      }
    };
  }
}
