package com.biz.crm.common.message.feign.service.internal;

import com.biz.crm.common.message.feign.feign.SendMessageVoServiceFeign;
import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.sdk.service.SendMessageVoService;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 系统消息sdk feign实现
 *
 * @author sunx
 * @date 2022/7/5
 */
@Slf4j
@Service
public class SendMessageVoServiceImpl implements SendMessageVoService {

  @Autowired(required = false)
  private SendMessageVoServiceFeign sendMessageVoServiceFeign;

  @Override
  public void send(SysMessageDto dto) {
    this.sendMessageVoServiceFeign.send(dto);
  }

  @Override
  public void batchSend(List<SysMessageDto> list) {
    this.sendMessageVoServiceFeign.sendBatch(list);
  }
}
