package com.biz.crm.common.message.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.feign.feign.internal.SendMessageVoServiceFeignImpl;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 消息feign
 *
 * @author sunx
 * @date 2022/7/5
 */
@FeignClient(
    name = "${msg.feign-client.name:crm-mdm}",
    path = "${msg.feign-client.path:crm-mdm}",
    fallbackFactory = SendMessageVoServiceFeignImpl.class)
public interface SendMessageVoServiceFeign {

  /**
   * 发送系统消息
   *
   * @param dto
   * @return
   */
  @PostMapping("/v1/systemMessage/send")
  Result<?> send(@RequestBody SysMessageDto dto);

  /**
   * 批量发送系统消息
   *
   * @param list
   * @return
   */
  @PostMapping("/v1/systemMessage/sendBatch")
  Result<?> sendBatch(@RequestBody List<SysMessageDto> list);
}
