package com.biz.crm.common.message.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.feign.feign.internal.SystemMessageVoServiceFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * 消息feign
 *
 * @author sunx
 * @date 2022/7/5
 */
@FeignClient(url= "${feign.urlip:}",
    name = "${msg.feign-client.name:crm-mdm}",
    path = "${msg.feign-client.path:crm-mdm}",
    fallbackFactory = SystemMessageVoServiceFeignImpl.class)
public interface SystemMessageVoServiceFeign {

  /**
   * 系统首页获取消息未读
   *
   * @return
   */
  @GetMapping("/v1/systemMessage/systemMessage/findHomeNotReadCount")
  Result<Integer> findHomeNotReadCount();

}
