package com.biz.crm.common.message.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.feign.feign.SystemMessageVoServiceFeign;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;


/**
 * 消息feign实现
 *
 * @author sunx
 * @date 2022/7/5
 */
@Component
public class SystemMessageVoServiceFeignImpl implements FallbackFactory<SystemMessageVoServiceFeign> {

  @Override
  public SystemMessageVoServiceFeign create(Throwable throwable) {
    return new SystemMessageVoServiceFeign() {
      /**
       * 系统首页获取消息未读
       *
       * @return
       */
      @Override
      public Result<Integer> findHomeNotReadCount() {
        throw new UnsupportedOperationException("系统首页获取消息未读熔断");
        }
      };
    }
}
