package com.biz.crm.common.message.feign.service.internal;

import com.biz.crm.common.message.feign.feign.SystemMessageVoServiceFeign;
import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.service.SystemMessageVoService;
import com.biz.crm.common.message.sdk.vo.SystemMessageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * 系统消息sdk实现
 *
 * @author sunx
 * @date 2022/7/5
 */

@Service
public class SystemMessageVoServiceImpl implements SystemMessageVoService {

  @Autowired(required = false)
  private SystemMessageVoServiceFeign systemMessageVoServiceFeign;

  /**
   * 消息保存
   *
   * @param messageCode 通知类型编码
   * @param list        消息明细dto集合
   * @param content     内容
   * @return 消息信息
   */
  @Override
  public List<SystemMessageVo> create(String messageCode, List<SysMessageItemDto> list, String content) {
    throw new UnsupportedOperationException();
  }

  /**
   * 系统首页获取消息未读
   *
   * @return
   */
  @Override
  public Integer findHomeNotReadCount() {
    return this.systemMessageVoServiceFeign.findHomeNotReadCount().getResult();
  }
}
