package com.biz.crm.common.message.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author sunx
 * @date 2022/7/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sys_message")
@Table(name = "sys_message")
@ApiModel(value = "SystemMessage", description = "系统消息")
@org.hibernate.annotations.Table(appliesTo = "sys_message", comment = "系统消息")
public class SystemMessage extends TenantFlagOpEntity {

  /** 关联业务员编码 */
  @ApiModelProperty("关联业务员编码")
  @TableField(value = "business_code")
  @Column(name = "business_code", length = 64, columnDefinition = "varchar(64) COMMENT '关联业务员编码'")
  private String businessCode;

  /** 关联业务员类型 */
  @ApiModelProperty("关联业务员类型")
  @TableField(value = "business_type")
  @Column(name = "business_type", length = 64, columnDefinition = "varchar(64) COMMENT '关联业务员类型'")
  private String businessType;

  /** 关联业务单据号 */
  @ApiModelProperty("关联业务单据号")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", length = 64, columnDefinition = "varchar(64) COMMENT '关联业务单据号'")
  private String relateCode;

  /** 关联业务类型 */
  @ApiModelProperty("关联业务类型")
  @TableField(value = "relate_type")
  @Column(name = "relate_type", length = 64, columnDefinition = "varchar(64) COMMENT '关联业务单类型'")
  private String relateType;

  /** 消息通知类型编码 */
  @ApiModelProperty("消息通知类型编码")
  @TableField(value = "message_code")
  @Column(name = "message_code", length = 64, columnDefinition = "varchar(64) COMMENT '消息通知类型编码'")
  private String messageCode;

  /** 消息内容 */
  @ApiModelProperty("消息内容")
  @TableField(value = "content")
  @Column(name = "content", length = 200, columnDefinition = "varchar(200) COMMENT '消息内容'")
  private String content;

  /** 是否已读 */
  @ApiModelProperty("是否已读")
  @TableField(value = "read_flag")
  @Column(name = "read_flag", columnDefinition = "bit(1) COMMENT '是否已读'")
  private Boolean readFlag;

  /** 消息通知类型名称 */
  @ApiModelProperty("消息通知类型名称")
  @Transient
  @TableField(exist = false)
  private String messageName;
}
