package com.biz.crm.common.message.local.service.internal;

import com.biz.crm.common.message.local.entity.SystemMessage;
import com.biz.crm.common.message.local.service.SystemMessageService;
import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.service.SystemMessageVoService;
import com.biz.crm.common.message.sdk.util.ContentHolderUtil;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 系统消息sdk实现
 *
 * @author sunx
 * @date 2022/7/5
 */
@Slf4j
@Service
public class SystemMessageVoServiceImpl implements SystemMessageVoService {

  @Autowired private SystemMessageService systemMessageService;

  @Override
  @Transactional
  public void create(String messageCode, List<SysMessageItemDto> list, String content) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    List<SystemMessage> data = Lists.newArrayList();
    for (SysMessageItemDto item : list) {
      final SystemMessage cur = new SystemMessage();
      cur.setReadFlag(false);
      cur.setBusinessCode(item.getBusinessCode());
      cur.setBusinessType(item.getBusinessType());
      cur.setRelateCode(item.getRelateCode());
      cur.setRelateType(item.getRelateType());
      cur.setMessageCode(messageCode);
      cur.setContent(ContentHolderUtil.replacePlaceHolder(content, item.getParamsMap()));
      cur.setTenantCode(TenantUtils.getTenantCode());
      data.add(cur);
    }
    this.systemMessageService.createBatch(data);
  }
}
